/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedUnregisterRouteTest
extends ManagementTestSupport {
    public void testUnregisterRoute() throws Exception {
        if (ManagedUnregisterRouteTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route1\"");
        ManagedUnregisterRouteTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String id = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedUnregisterRouteTest.assertEquals((String)"route1", (String)id);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedUnregisterRouteTest.assertEquals((String)"camel-1", (String)camelId);
        this.context.stop();
        ManagedUnregisterRouteTest.assertFalse((String)"Should no longer be registered", (boolean)mbeanServer.isRegistered(on));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

