/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.event.CamelContextStartedEvent;
import org.apache.camel.management.event.CamelContextStartingEvent;
import org.apache.camel.management.event.CamelContextStoppedEvent;
import org.apache.camel.management.event.CamelContextStoppingEvent;
import org.apache.camel.management.event.ExchangeCompletedEvent;
import org.apache.camel.management.event.ExchangeCreatedEvent;
import org.apache.camel.management.event.ExchangeFailedEvent;
import org.apache.camel.management.event.ExchangeSendingEvent;
import org.apache.camel.management.event.ExchangeSentEvent;
import org.apache.camel.management.event.RouteAddedEvent;
import org.apache.camel.management.event.RouteRemovedEvent;
import org.apache.camel.management.event.RouteStartedEvent;
import org.apache.camel.management.event.RouteStoppedEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.EventNotifierSupport;

public class MultipleEventNotifierEventsTest
extends ContextTestSupport {
    private static List<EventObject> events = new ArrayList<EventObject>();
    private static List<EventObject> events2 = new ArrayList<EventObject>();

    @Override
    protected boolean useJmx() {
        return true;
    }

    @Override
    public void setUp() throws Exception {
        events.clear();
        events2.clear();
        super.setUp();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)this.createRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(EventObject event) throws Exception {
                events.add(event);
            }

            public boolean isEnabled(EventObject event) {
                return true;
            }

            protected void doStart() throws Exception {
            }

            protected void doStop() throws Exception {
            }
        });
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(EventObject event) throws Exception {
                events2.add(event);
            }

            public boolean isEnabled(EventObject event) {
                return true;
            }

            protected void doStart() throws Exception {
                this.setIgnoreCamelContextEvents(true);
                this.setIgnoreServiceEvents(true);
                this.setIgnoreRouteEvents(true);
            }

            protected void doStop() throws Exception {
            }
        });
        return context;
    }

    public void testExchangeDone() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MultipleEventNotifierEventsTest.assertEquals((int)14, (int)events.size());
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextStartingEvent.class, events.get(0));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteAddedEvent.class, events.get(1));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteAddedEvent.class, events.get(2));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStartedEvent.class, events.get(3));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStartedEvent.class, events.get(4));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextStartedEvent.class, events.get(5));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(6));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, events.get(7));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(8));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(9));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(10));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(11));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeCompletedEvent.class, events.get(12));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(13));
        MultipleEventNotifierEventsTest.assertEquals((int)8, (int)events2.size());
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, events2.get(0));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, events2.get(1));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, events2.get(2));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events2.get(3));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, events2.get(4));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events2.get(5));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeCompletedEvent.class, events2.get(6));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events2.get(7));
        this.context.stop();
        MultipleEventNotifierEventsTest.assertEquals((int)20, (int)events.size());
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextStoppingEvent.class, events.get(14));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStoppedEvent.class, events.get(15));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteRemovedEvent.class, events.get(16));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStoppedEvent.class, events.get(17));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteRemovedEvent.class, events.get(18));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextStoppedEvent.class, events.get(19));
        MultipleEventNotifierEventsTest.assertEquals((int)8, (int)events2.size());
    }

    public void testExchangeFailed() throws Exception {
        try {
            this.template.sendBody("direct:fail", (Object)"Hello World");
            MultipleEventNotifierEventsTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            MultipleEventNotifierEventsTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        }
        MultipleEventNotifierEventsTest.assertEquals((int)10, (int)events.size());
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextStartingEvent.class, events.get(0));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteAddedEvent.class, events.get(1));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteAddedEvent.class, events.get(2));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStartedEvent.class, events.get(3));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStartedEvent.class, events.get(4));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextStartedEvent.class, events.get(5));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(6));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, events.get(7));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeFailedEvent.class, events.get(8));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(9));
        MultipleEventNotifierEventsTest.assertEquals((int)4, (int)events2.size());
        this.context.stop();
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, events2.get(0));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, events2.get(1));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeFailedEvent.class, events2.get(2));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, events2.get(3));
        MultipleEventNotifierEventsTest.assertEquals((int)16, (int)events.size());
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextStoppingEvent.class, events.get(10));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStoppedEvent.class, events.get(11));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteRemovedEvent.class, events.get(12));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStoppedEvent.class, events.get(13));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteRemovedEvent.class, events.get(14));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextStoppedEvent.class, events.get(15));
        MultipleEventNotifierEventsTest.assertEquals((int)4, (int)events2.size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
                this.from("direct:fail").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }
}

