/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.PublishEventNotifier;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Registry;

public class PublishEventNotifierTest
extends ContextTestSupport {
    @Override
    protected boolean useJmx() {
        return true;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)this.createRegistry());
        PublishEventNotifier notifier = new PublishEventNotifier();
        notifier.setCamelContext((CamelContext)context);
        notifier.setEndpointUri("mock:event");
        context.getManagementStrategy().addEventNotifier((EventNotifier)notifier);
        return context;
    }

    public void testExchangeDone() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:event").expectedMessageCount(9);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testExchangeFailed() throws Exception {
        this.getMockEndpoint("mock:event").expectedMessageCount(5);
        try {
            this.template.sendBody("direct:fail", (Object)"Hello World");
            PublishEventNotifierTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            PublishEventNotifierTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
                this.from("direct:fail").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }
}

