/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.TestSupport;
import org.apache.camel.impl.DefaultCamelContext;

public class TwoManagedCamelContextTest
extends TestSupport {
    private CamelContext camel1;
    private CamelContext camel2;

    protected CamelContext createCamelContext(String name) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.setName(name);
        return context;
    }

    public void testTwoManagedCamelContext() throws Exception {
        if (TwoManagedCamelContextTest.isPlatform("aix")) {
            return;
        }
        this.camel1 = this.createCamelContext("foo");
        this.camel2 = this.createCamelContext("bar");
        this.camel1.start();
        this.camel2.start();
        MBeanServer mbeanServer = this.camel1.getManagementStrategy().getManagementAgent().getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=foo,type=context,name=\"foo\"");
        TwoManagedCamelContextTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        ObjectName on2 = ObjectName.getInstance("org.apache.camel:context=bar,type=context,name=\"bar\"");
        TwoManagedCamelContextTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on2));
        this.camel1.stop();
        this.camel2.stop();
        TwoManagedCamelContextTest.assertFalse((String)"Should be unregistered", (boolean)mbeanServer.isRegistered(on));
        TwoManagedCamelContextTest.assertFalse((String)"Should be unregistered", (boolean)mbeanServer.isRegistered(on2));
    }

    protected void tearDown() throws Exception {
        if (this.camel1 != null) {
            this.camel1.stop();
        }
        if (this.camel2 != null) {
            this.camel2.stop();
        }
        super.tearDown();
    }
}

