/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.Marshaller;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.XmlTestSupport;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.GroovyExpression;
import org.apache.camel.model.language.XQueryExpression;

public class GenerateXmlTest
extends XmlTestSupport {
    public void testCreateSimpleXml() throws Exception {
        RoutesDefinition context = new RoutesDefinition();
        RouteDefinition route = context.route();
        route.from("seda:a");
        route.filter((ExpressionDefinition)new XQueryExpression("in.header.foo == 'bar'")).to("seda:b");
        route.description(null, "This is a description of the route", "en");
        this.dump((RouteContainer)context);
    }

    public void testGroovyFilterXml() throws Exception {
        RoutesDefinition context = new RoutesDefinition();
        RouteDefinition route = context.route();
        route.from("seda:a");
        route.filter((ExpressionDefinition)new GroovyExpression("in.headers.any { h -> h.startsWith('foo') }")).to("seda:b");
        route.description(null, "This is a description of the route", "en");
        List list = route.getOutputs();
        GenerateXmlTest.assertEquals((String)("Size of list: " + list), (int)1, (int)list.size());
        this.dump((RouteContainer)context);
    }

    protected void dump(RouteContainer context) throws Exception {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter buffer = new StringWriter();
        marshaller.marshal((Object)context, (Writer)buffer);
        this.log.info("Created: " + buffer);
        GenerateXmlTest.assertNotNull((Object)buffer);
        String out = buffer.toString();
        GenerateXmlTest.assertTrue((String)"Should contain the description", (out.indexOf("This is a description of the route") > 0 ? 1 : 0) != 0);
    }
}

