/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.io.InputStream;
import java.util.Collection;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RoutesDefinition;

public class LoadRouteFromXmlWithOnExceptionTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myProcessor", (Object)new MyProcessor());
        return jndi;
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testLoadRouteFromXmlWitOnException() throws Exception {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("barOnExceptionRoute.xml");
        RoutesDefinition routes = this.context.loadRoutesDefinition(is);
        this.context.addRouteDefinitions((Collection)routes.getRoutes());
        this.context.start();
        LoadRouteFromXmlWithOnExceptionTest.assertNotNull((String)"Loaded bar route should be there", (Object)this.context.getRoute("bar"));
        LoadRouteFromXmlWithOnExceptionTest.assertEquals((int)1, (int)this.context.getRoutes().size());
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Kabom"});
        this.template.sendBody("direct:bar", (Object)"Bye World");
        this.template.sendBody("direct:bar", (Object)"Kabom");
        this.assertMockEndpointsSatisfied();
    }

    private static final class MyProcessor
    implements Processor {
        private MyProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            if ("Kabom".equals(body)) {
                throw new IllegalArgumentException("Damn");
            }
        }
    }
}

