/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ProcessorBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class DeadLetterChannelRedeliveryDelayPatternTest
extends ContextTestSupport {
    private static int counter;

    public void testDelayPatternTest() throws Exception {
        counter = 0;
        MockEndpoint mock = this.getMockEndpoint("mock:error");
        mock.expectedMessageCount(1);
        long start = System.currentTimeMillis();
        this.template.sendBody("direct:start", (Object)"Hello World");
        long delta = System.currentTimeMillis() - start;
        DeadLetterChannelRedeliveryDelayPatternTest.assertTrue((String)"Should be slower", (delta > 1000L ? 1 : 0) != 0);
        this.assertMockEndpointsSatisfied();
        DeadLetterChannelRedeliveryDelayPatternTest.assertEquals((int)3, (int)counter);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").delayPattern("0:250;2:500").maximumRedeliveries(3).onRedelivery(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        counter++;
                    }
                }));
                this.from("direct:start").process(ProcessorBuilder.throwException((Exception)new Exception("Forced exception by unit test")));
            }
        };
    }
}

