/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.processor.DefaultExchangeFormatter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultExchangeFormatterTest {
    private DefaultCamelContext camelContext;
    private Exchange exchange;
    private DefaultExchangeFormatter exchangeFormatter;

    @Before
    public void setUp() {
        this.camelContext = new DefaultCamelContext();
        DefaultMessage message = new DefaultMessage();
        message.setBody((Object)"This is the message body");
        this.exchange = new DefaultExchange((CamelContext)this.camelContext);
        this.exchange.setIn((Message)message);
        this.exchangeFormatter = new DefaultExchangeFormatter();
    }

    @Test
    public void testDefaultFormat() {
        String formattedExchange = this.exchangeFormatter.format(this.exchange);
        Assert.assertTrue((boolean)formattedExchange.contains("This is the message body"));
    }

    @Test
    public void testFormatWithMaxCharsParameter() {
        this.exchangeFormatter.setMaxChars(60);
        String formattedExchange = this.exchangeFormatter.format(this.exchange);
        Assert.assertEquals((long)(60 + "Exchange[...]".length() - ", ".length()), (long)formattedExchange.length());
    }

    @Test
    public void testFormatWithBodyMaxChars() {
        this.camelContext.getProperties().put("CamelLogDebugBodyMaxChars", "7");
        String formattedExchange = this.exchangeFormatter.format(this.exchange);
        Assert.assertFalse((boolean)formattedExchange.contains("This is "));
        Assert.assertTrue((boolean)formattedExchange.contains("This is"));
        this.camelContext.getProperties().remove("CamelLogDebugBodyMaxChars");
    }

    @Test
    public void testFormatWithBoth() {
        this.camelContext.getProperties().put("CamelLogDebugBodyMaxChars", "7");
        this.exchangeFormatter.setMaxChars(60);
        String formattedExchange = this.exchangeFormatter.format(this.exchange);
        Assert.assertEquals((long)(60 + "Exchange[...]".length() - ", ".length()), (long)formattedExchange.length());
        Assert.assertFalse((boolean)formattedExchange.contains("This is "));
        this.camelContext.getProperties().remove("CamelLogDebugBodyMaxChars");
    }
}

