/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.model.RouteDefinition;

public class DefaultScheduledPollConsumerBridgeErrorHandlerTest
extends ContextTestSupport {
    public void testDefaultConsumerBridgeErrorHandler() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMinimumMessageCount(1);
        this.assertMockEndpointsSatisfied();
        Exception cause = (Exception)((Exchange)this.getMockEndpoint("mock:dead").getReceivedExchanges().get(0)).getProperty("CamelExceptionCaught", Exception.class);
        DefaultScheduledPollConsumerBridgeErrorHandlerTest.assertNotNull((Object)cause);
        DefaultScheduledPollConsumerBridgeErrorHandlerTest.assertEquals((String)"Simulated", (String)cause.getMessage());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.getContext().addComponent("my", (Component)new MyComponent());
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead"));
                ((RouteDefinition)this.from("my:foo?consumer.bridgeErrorHandler=true").to("log:foo")).to("mock:result");
            }
        };
    }

    public static class MyConsumer
    extends ScheduledPollConsumer {
        public MyConsumer(Endpoint endpoint, Processor processor) {
            super(endpoint, processor);
        }

        protected int poll() throws Exception {
            throw new IllegalArgumentException("Simulated");
        }
    }

    public static class MyEndpoint
    extends DefaultEndpoint {
        public MyEndpoint(String endpointUri, Component component) {
            super(endpointUri, component);
        }

        public Producer createProducer() throws Exception {
            return null;
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            MyConsumer answer = new MyConsumer((Endpoint)this, processor);
            this.configureConsumer((Consumer)answer);
            return answer;
        }

        public boolean isSingleton() {
            return true;
        }
    }

    public static class MyComponent
    extends DefaultComponent {
        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            return new MyEndpoint(uri, (Component)this);
        }
    }
}

