/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.EvaluateExpressionProcessor;

public class EvaluateExpressionProcessorTest
extends ContextTestSupport {
    public void testOk() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"World"});
        mock.expectedPropertyReceived("CamelEvaluateExpressionResult", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    public void testFail() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:fail", (Object)"World");
            EvaluateExpressionProcessorTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            EvaluateExpressionProcessorTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            EvaluateExpressionProcessorTest.assertEquals((String)"Forced", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").process((Processor)new EvaluateExpressionProcessor((Expression)this.body().prepend((Object)"Hello ")))).to("mock:result");
                ((RouteDefinition)this.from("direct:fail").process((Processor)new EvaluateExpressionProcessor(new Expression(){

                    public <T> T evaluate(Exchange exchange, Class<T> type) {
                        throw new IllegalArgumentException("Forced");
                    }
                }))).to("mock:result");
            }
        };
    }
}

