/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.model.RouteDefinition;

public class ExceptionHandlerStreamCacheTest
extends ContextTestSupport {
    private MockEndpoint successEndpoint;
    private MockEndpoint exceptionEndpoint;

    public void testSendFault() throws Exception {
        this.doTestInputStreamPayload("fault");
    }

    public void testSendError() throws Exception {
        this.doTestInputStreamPayload("error");
    }

    private void doTestInputStreamPayload(String message) throws InterruptedException, IOException {
        this.successEndpoint.expectedMessageCount(0);
        this.exceptionEndpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)new ByteArrayInputStream(message.getBytes()));
        this.successEndpoint.assertIsSatisfied();
        this.exceptionEndpoint.assertIsSatisfied();
        InputStream body = (InputStream)((Exchange)this.exceptionEndpoint.getExchanges().get(0)).getIn().getBody();
        ExceptionHandlerStreamCacheTest.assertEquals((String)"Ensure message re-readability in the exception handler", (String)message, (String)new String(IOConverter.toBytes((InputStream)body)));
    }

    public void testSendFaultXml() throws Exception {
        this.doTestXmlPayload("<fault/>");
    }

    public void testSendErrorXml() throws Exception {
        this.doTestXmlPayload("<error/>");
    }

    private void doTestXmlPayload(String xml) throws InterruptedException, TransformerException {
        this.successEndpoint.expectedMessageCount(0);
        this.exceptionEndpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)new StreamSource(new ByteArrayInputStream(xml.getBytes())));
        this.successEndpoint.assertIsSatisfied();
        this.exceptionEndpoint.assertIsSatisfied();
        StreamSource body = (StreamSource)((Exchange)this.exceptionEndpoint.getExchanges().get(0)).getIn().getBody();
        ExceptionHandlerStreamCacheTest.assertEquals((String)"Ensure message re-readability in the exception handler", (String)xml, (String)new XmlConverter().toString((Source)body, null));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.exceptionEndpoint = this.getMockEndpoint("mock:exception");
        this.successEndpoint = this.getMockEndpoint("mock:success");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ExceptionHandlerStreamCacheTest.this.context.setHandleFault(Boolean.valueOf(true));
                ExceptionHandlerStreamCacheTest.this.context.setStreamCaching(Boolean.valueOf(true));
                this.onException(Exception.class).handled(true).to("mock:exception");
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String message = (String)exchange.getIn().getBody(String.class);
                        if (message.contains("fault")) {
                            exchange.getOut().copyFrom(exchange.getIn());
                            exchange.getOut().setBody((Object)new ByteArrayInputStream(message.getBytes()));
                            exchange.getOut().setFault(true);
                        }
                        if (message.contains("error")) {
                            throw new RuntimeException(message);
                        }
                    }
                })).to("mock:success");
            }
        };
    }
}

