/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class FilterBeforeSplitTest
extends ContextTestSupport {
    public void testFilterBeforeSplit() throws Exception {
        this.getMockEndpoint("mock:good").expectedBodiesReceived(new Object[]{"Hello World how are you?"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello,World,how,are,you?"});
        MockEndpoint split = this.getMockEndpoint("mock:split");
        split.expectedBodiesReceived(new Object[]{"Hello", "World", "how", "are", "you?"});
        this.template.sendBody("direct:start", (Object)"Hello World how are you?");
        this.assertMockEndpointsSatisfied();
    }

    public void testFiltered() throws Exception {
        this.getMockEndpoint("mock:good").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"I will be filtered", "Hello World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"I,will,be,filtered", "Hello,World"});
        this.getMockEndpoint("mock:split").expectedBodiesReceived(new Object[]{"I", "will", "be", "filtered", "Hello", "World"});
        this.template.sendBody("direct:start", (Object)"I will be filtered");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                Predicate goodWord = this.body().contains((Object)"World");
                ((ExpressionNode)((ExpressionNode)((RouteDefinition)this.from("direct:start").to("mock:before")).filter(goodWord).to("mock:good")).end().split((Expression)this.body().tokenize(" "), (AggregationStrategy)new MyAggregationStrategy()).to("mock:split")).end().to("mock:result");
            }
        };
    }

    protected class MyAggregationStrategy
    implements AggregationStrategy {
        protected MyAggregationStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            String newBody = (String)newExchange.getIn().getBody(String.class);
            if (oldExchange == null) {
                return newExchange;
            }
            String body = (String)oldExchange.getIn().getBody(String.class);
            body = body + "," + newBody;
            oldExchange.getIn().setBody((Object)body);
            return oldExchange;
        }
    }
}

