/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.spi.IdempotentRepository;

public class IdempotentConsumerEagerTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testDuplicateMessagesAreFilteredOut() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), MemoryIdempotentRepository.memoryIdempotentRepository((int)200)).eager(false).to("mock:result");
            }
        });
        this.context.start();
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"one", "two", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("3", "three");
        this.assertMockEndpointsSatisfied();
    }

    public void testFailedExchangesNotAddedDeadLetterChannel() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").maximumRedeliveries(2).redeliveryDelay(0L).logStackTrace(false));
                ((ExpressionNode)this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), MemoryIdempotentRepository.memoryIdempotentRepository((int)200)).eager(false).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String id = (String)exchange.getIn().getHeader("messageId", String.class);
                        if (id.equals("2")) {
                            throw new IllegalArgumentException("Damm I cannot handle id 2");
                        }
                    }
                })).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:error").expectedMessageCount(2);
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"one", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("3", "three");
        this.assertMockEndpointsSatisfied();
    }

    public void testFailedExchangesNotAdded() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), MemoryIdempotentRepository.memoryIdempotentRepository((int)200)).eager(false).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String id = (String)exchange.getIn().getHeader("messageId", String.class);
                        if (id.equals("2")) {
                            throw new IllegalArgumentException("Damm I cannot handle id 2");
                        }
                    }
                })).to("mock:result");
            }
        });
        this.context.start();
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"one", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("3", "three");
        this.assertMockEndpointsSatisfied();
    }

    public void testNotEager() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                final IdempotentRepository repo = MemoryIdempotentRepository.memoryIdempotentRepository((int)200);
                ((ExpressionNode)this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), repo).eager(false).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String id = (String)exchange.getIn().getHeader("messageId", String.class);
                        TestCase.assertFalse((String)"Should not eager add to repo", (boolean)repo.contains((Object)id));
                    }
                })).to("mock:result");
            }
        });
        this.context.start();
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"one", "two", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("3", "three");
        this.assertMockEndpointsSatisfied();
    }

    public void testEager() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                final IdempotentRepository repo = MemoryIdempotentRepository.memoryIdempotentRepository((int)200);
                ((ExpressionNode)this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), repo).eager(true).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String id = (String)exchange.getIn().getHeader("messageId", String.class);
                        TestCase.assertTrue((String)"Should eager add to repo", (boolean)repo.contains((Object)id));
                    }
                })).to("mock:result");
            }
        });
        this.context.start();
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"one", "two", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("3", "three");
        this.assertMockEndpointsSatisfied();
    }

    protected void sendMessage(final Object messageId, final Object body) {
        this.template.send(this.startEndpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("messageId", messageId);
            }
        });
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }
}

