/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;

public class LoopTestProcessor
implements Processor {
    private int count;
    private int index;

    public LoopTestProcessor() {
    }

    public LoopTestProcessor(int count) {
        this.setCount(count);
    }

    public void setCount(int count) {
        this.count = count;
        this.reset();
    }

    public void reset() {
        this.index = 0;
    }

    public void process(Exchange exchange) {
        Integer c = (Integer)exchange.getProperty("CamelLoopSize", Integer.class);
        Integer i = (Integer)exchange.getProperty("CamelLoopIndex", Integer.class);
        if (c == null || c != this.count) {
            exchange.setException((Throwable)new CamelException("Invalid count value.  Expected " + this.count + " but was " + c));
        }
        if (i == null || i != this.index++) {
            exchange.setException((Throwable)new CamelException("Invalid index value.  Expected " + this.index + " but was " + i));
        }
    }
}

