/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.GroupedExchangeAggregationStrategy;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class MulticastGroupedExchangeExceptionTest
extends ContextTestSupport {
    public void testBothGood() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"dummy");
        this.assertMockEndpointsSatisfied();
        Exchange received = (Exchange)result.getReceivedExchanges().get(0);
        MatcherAssert.assertThat((String)"no exception", (Object)received.isFailed(), (Matcher)CoreMatchers.is((Object)false));
    }

    public void testBFail() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        MockEndpoint endpointB = this.getMockEndpoint("mock:endpointB");
        endpointB.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                throw new IllegalArgumentException("Fake exception");
            }
        });
        this.template.sendBody("direct:start", (Object)"dummy");
        this.assertMockEndpointsSatisfied();
        Exchange received = (Exchange)result.getReceivedExchanges().get(0);
        MatcherAssert.assertThat((String)"no exception", (Object)received.isFailed(), (Matcher)CoreMatchers.is((Object)false));
    }

    public void testAFail() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        MockEndpoint endpointA = this.getMockEndpoint("mock:endpointA");
        endpointA.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                throw new IllegalArgumentException("Fake exception");
            }
        });
        this.template.sendBody("direct:start", (Object)"dummy");
        this.assertMockEndpointsSatisfied();
        Exchange received = (Exchange)result.getReceivedExchanges().get(0);
        MatcherAssert.assertThat((String)"no exception", (Object)received.isFailed(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.from("direct:start").multicast((AggregationStrategy)new GroupedExchangeAggregationStrategy()).to(new String[]{"mock:endpointA", "mock:endpointB"})).end().to("mock:result");
            }
        };
    }
}

