/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class MulticastParallelStreamingTest
extends ContextTestSupport {
    public void testMulticastParallelStreaming() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"BA"});
        this.template.sendBody("direct:start", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    public void testMulticastParallel() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(10);
        mock.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                TestCase.assertEquals((String)"BA", (String)((String)exchange.getIn().getBody(String.class)));
            }
        });
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("direct:start", (Object)"Hello");
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.from("direct:start").multicast(new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        if (oldExchange == null) {
                            return newExchange;
                        }
                        String body = (String)oldExchange.getIn().getBody(String.class);
                        oldExchange.getIn().setBody((Object)(body + (String)newExchange.getIn().getBody(String.class)));
                        return oldExchange;
                    }
                }).parallelProcessing().streaming().to(new String[]{"direct:a", "direct:b"})).end().to("mock:result");
                this.from("direct:a").delay(500L).setBody((Expression)this.constant("A"));
                this.from("direct:b").setBody((Expression)this.constant("B"));
            }
        };
    }
}

