/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.TraceEventMessage;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;

public class OnCompletionGlobalTraceTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myProcessor", (Object)new MyProcessor());
        return jndi;
    }

    public void testSynchronizeComplete() throws Exception {
        this.getMockEndpoint("mock:sync").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:sync").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        this.getMockEndpoint("mock:trace").expectedMessageCount(4);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        TraceEventMessage msg1 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(0)).getIn().getBody(TraceEventMessage.class);
        TraceEventMessage msg2 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(1)).getIn().getBody(TraceEventMessage.class);
        TraceEventMessage msg3 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(2)).getIn().getBody(TraceEventMessage.class);
        TraceEventMessage msg4 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(3)).getIn().getBody(TraceEventMessage.class);
        OnCompletionGlobalTraceTest.assertEquals((String)"direct://start", (String)msg1.getFromEndpointUri());
        OnCompletionGlobalTraceTest.assertEquals((String)"ref:myProcessor", (String)msg1.getToNode());
        OnCompletionGlobalTraceTest.assertEquals((String)"ref:myProcessor", (String)msg2.getPreviousNode());
        OnCompletionGlobalTraceTest.assertEquals((String)"mock://result", (String)msg2.getToNode());
        OnCompletionGlobalTraceTest.assertTrue((boolean)msg3.getPreviousNode().startsWith("OnCompletion"));
        OnCompletionGlobalTraceTest.assertEquals((String)"log://global", (String)msg3.getToNode());
        OnCompletionGlobalTraceTest.assertEquals((String)"log://global", (String)msg4.getPreviousNode());
        OnCompletionGlobalTraceTest.assertEquals((String)"mock://sync", (String)msg4.getToNode());
    }

    public void testSynchronizeFailure() throws Exception {
        this.getMockEndpoint("mock:sync").expectedMessageCount(1);
        this.getMockEndpoint("mock:sync").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        this.getMockEndpoint("mock:trace").expectedMessageCount(3);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Kabom");
            OnCompletionGlobalTraceTest.fail((String)"Should throw exception");
        }
        catch (CamelExecutionException e) {
            OnCompletionGlobalTraceTest.assertEquals((String)"Kabom", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        TraceEventMessage msg1 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(0)).getIn().getBody(TraceEventMessage.class);
        TraceEventMessage msg2 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(1)).getIn().getBody(TraceEventMessage.class);
        TraceEventMessage msg3 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(2)).getIn().getBody(TraceEventMessage.class);
        OnCompletionGlobalTraceTest.assertEquals((String)"direct://start", (String)msg1.getFromEndpointUri());
        OnCompletionGlobalTraceTest.assertEquals((String)"ref:myProcessor", (String)msg1.getToNode());
        OnCompletionGlobalTraceTest.assertTrue((boolean)msg2.getPreviousNode().startsWith("OnCompletion"));
        OnCompletionGlobalTraceTest.assertEquals((String)"log://global", (String)msg2.getToNode());
        OnCompletionGlobalTraceTest.assertEquals((String)"log://global", (String)msg3.getPreviousNode());
        OnCompletionGlobalTraceTest.assertEquals((String)"mock://sync", (String)msg3.getToNode());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                Tracer tracer = new Tracer();
                tracer.setDestinationUri("mock:trace");
                OnCompletionGlobalTraceTest.this.context.addInterceptStrategy((InterceptStrategy)tracer);
                ((OnCompletionDefinition)this.onCompletion().to("log:global")).to("mock:sync");
                ((RouteDefinition)this.from("direct:start").processRef("myProcessor")).to("mock:result");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            if ("Kabom".equals(exchange.getIn().getBody())) {
                throw new IllegalArgumentException("Kabom");
            }
            exchange.getIn().setBody((Object)"Bye World");
        }
    }
}

