/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;

public class RecipientListExchangePropertyTest
extends ContextTestSupport {
    private final MyStuff myStuff = new MyStuff("Blah");

    public void testExchangeProperty() throws Exception {
        this.getMockEndpoint("mock:x").expectedBodiesReceived(new Object[]{"Hello World"});
        ((ValueBuilder)this.getMockEndpoint("mock:x").message(0).exchangeProperty("foo")).isEqualTo((Object)this.myStuff);
        this.getMockEndpoint("mock:y").expectedBodiesReceived(new Object[]{"Hello World"});
        ((ValueBuilder)this.getMockEndpoint("mock:y").message(0).exchangeProperty("foo")).isEqualTo((Object)this.myStuff);
        this.getMockEndpoint("mock:z").expectedBodiesReceived(new Object[]{"Hello World"});
        ((ValueBuilder)this.getMockEndpoint("mock:z").message(0).exchangeProperty("foo")).isEqualTo((Object)this.myStuff);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        ((ValueBuilder)this.getMockEndpoint("mock:result").message(0).exchangeProperty("foo")).isEqualTo((Object)this.myStuff);
        this.template.sendBodyAndProperty("direct:a", (Object)"Hello World", "foo", (Object)this.myStuff);
        this.assertMockEndpointsSatisfied();
        MyStuff stuff = (MyStuff)((Exchange)this.getMockEndpoint("mock:result").getReceivedExchanges().get(0)).getProperty("foo", MyStuff.class);
        RecipientListExchangePropertyTest.assertSame((String)"Should be same instance", (Object)this.myStuff, (Object)stuff);
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").recipientList((Expression)this.constant("mock:x,mock:y,mock:z")).to("mock:result");
            }
        };
    }

    private static final class MyStuff {
        private String name;

        private MyStuff(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

