/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RecipientList;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class RecipientListParallelFineGrainedErrorHandlingTest
extends ContextTestSupport {
    private static int counter;

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("fail", (Object)new MyFailBean());
        return jndi;
    }

    public void testRecipientListOk() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).maximumRedeliveries(2);
                ((RouteDefinition)this.from("direct:start").to("mock:a")).recipientList((Expression)this.header("foo")).stopOnException().parallelProcessing();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"mock:foo,mock:bar,mock:baz");
        this.assertMockEndpointsSatisfied();
    }

    public void testRecipientListError() throws Exception {
        counter = 0;
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).maximumRedeliveries(2);
                ((RouteDefinition)this.from("direct:start").to("mock:a")).recipientList((Expression)this.header("foo")).stopOnException().parallelProcessing();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMinimumMessageCount(0);
        this.getMockEndpoint("mock:baz").expectedMinimumMessageCount(0);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"mock:foo,mock:bar,bean:fail,mock:baz");
            RecipientListParallelFineGrainedErrorHandlingTest.fail((String)"Should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
        RecipientListParallelFineGrainedErrorHandlingTest.assertEquals((int)3, (int)counter);
    }

    public void testRecipientListAsBeanError() throws Exception {
        counter = 0;
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                RecipientListParallelFineGrainedErrorHandlingTest.this.context.setTracing(Boolean.valueOf(true));
                this.onException(Exception.class).maximumRedeliveries(2);
                ((RouteDefinition)this.from("direct:start").to("mock:a")).bean(MyRecipientBean.class);
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMinimumMessageCount(0);
        this.getMockEndpoint("mock:baz").expectedMinimumMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            RecipientListParallelFineGrainedErrorHandlingTest.fail((String)"Should throw exception");
        }
        catch (CamelExecutionException e) {
            RecipientListParallelFineGrainedErrorHandlingTest.assertIsInstanceOf(CamelExchangeException.class, e.getCause());
            RecipientListParallelFineGrainedErrorHandlingTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause().getCause());
            RecipientListParallelFineGrainedErrorHandlingTest.assertEquals((String)"Damn", (String)e.getCause().getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        RecipientListParallelFineGrainedErrorHandlingTest.assertEquals((int)3, (int)counter);
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public static class MyFailBean {
        public String doSomething(Exchange exchange) throws Exception {
            counter++;
            TestCase.assertEquals((String)"bean://fail", (String)((String)exchange.getProperty("CamelToEndpoint", String.class)));
            throw new IllegalArgumentException("Damn");
        }
    }

    public static class MyRecipientBean {
        @RecipientList(stopOnException=true, parallelProcessing=true)
        public String sendSomewhere(Exchange exchange) {
            return "mock:foo,mock:bar,bean:fail,mock:baz";
        }
    }
}

