/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;

public class RecipientListRedeliverTest
extends ContextTestSupport {
    private static int counter;

    public void testOk() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "mySlip", (Object)"mock:a,mock:b");
        this.assertMockEndpointsSatisfied();
    }

    public void testThrowExceptionAtA() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "mySlip", (Object)"mock:a,direct:a,mock:b");
            RecipientListRedeliverTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            RecipientListRedeliverTest.assertEquals((String)"Forced", (String)e.getCause().getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        RecipientListRedeliverTest.assertEquals((int)4, (int)counter);
    }

    public void testThrowExceptionAtB() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "mySlip", (Object)"mock:a,mock:b,direct:b,mock:c");
            RecipientListRedeliverTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            RecipientListRedeliverTest.assertEquals((String)"Forced", (String)e.getCause().getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        RecipientListRedeliverTest.assertEquals((int)4, (int)counter);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.defaultErrorHandler().maximumRedeliveries(3).redeliveryDelay(0L));
                this.from("direct:start").recipientList((Expression)this.header("mySlip")).stopOnException();
                this.from("direct:a").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
                        TestCase.assertFalse((String)"Should not have OUT", (boolean)exchange.hasOut());
                        TestCase.assertNull((Object)exchange.getException());
                        counter++;
                        throw new IllegalArgumentException("Forced");
                    }
                });
                this.from("direct:b").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
                        TestCase.assertFalse((String)"Should not have OUT", (boolean)exchange.hasOut());
                        TestCase.assertNull((Object)exchange.getException());
                        exchange.getIn().setBody((Object)"Bye World");
                        counter++;
                        throw new IllegalArgumentException("Forced");
                    }
                });
            }
        };
    }
}

