/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class RedeliveryPolicyPerExceptionTest
extends ContextTestSupport {
    protected MockEndpoint a;
    protected MockEndpoint b;

    public void testUsingCustomExceptionHandlerAndOneRedelivery() throws Exception {
        this.a.expectedMessageCount(1);
        this.sendBody("direct:start", "a");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.a, this.b});
        List list = this.a.getReceivedExchanges();
        RedeliveryPolicyPerExceptionTest.assertTrue((String)"List should not be empty!", (!list.isEmpty() ? 1 : 0) != 0);
        Exchange exchange = (Exchange)list.get(0);
        Message in = exchange.getIn();
        this.log.info("Found message with headers: " + in.getHeaders());
        RedeliveryPolicyPerExceptionTest.assertMessageHeader(in, "CamelRedeliveryCounter", 2);
        RedeliveryPolicyPerExceptionTest.assertMessageHeader(in, "CamelRedeliveryMaxCounter", 2);
        RedeliveryPolicyPerExceptionTest.assertMessageHeader(in, "CamelRedelivered", true);
    }

    public void testUsingCustomExceptionHandlerWithNoRedeliveries() throws Exception {
        this.b.expectedMessageCount(1);
        this.sendBody("direct:start", "b");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.a, this.b});
        List list = this.b.getReceivedExchanges();
        RedeliveryPolicyPerExceptionTest.assertTrue((String)"List should not be empty!", (!list.isEmpty() ? 1 : 0) != 0);
        Exchange exchange = (Exchange)list.get(0);
        Message in = exchange.getIn();
        this.log.info("Found message with headers: " + in.getHeaders());
        RedeliveryPolicyPerExceptionTest.assertMessageHeader(in, "CamelRedeliveryCounter", 0);
        RedeliveryPolicyPerExceptionTest.assertMessageHeader(in, "CamelRedeliveryMaxCounter", null);
        RedeliveryPolicyPerExceptionTest.assertMessageHeader(in, "CamelRedelivered", false);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a = this.resolveMandatoryEndpoint("mock:a", MockEndpoint.class);
        this.b = this.resolveMandatoryEndpoint("mock:b", MockEndpoint.class);
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        final Processor processor = new Processor(){

            public void process(Exchange exchange) {
                if ("b".equals(exchange.getIn().getBody())) {
                    throw new NullPointerException("MyCustomException");
                }
                throw new IllegalArgumentException("MyCustomException");
            }
        };
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3));
                this.onException(IllegalArgumentException.class).maximumRedeliveries(2).to("mock:a");
                this.onException(NullPointerException.class).to("mock:b");
                this.from("direct:start").process(processor);
            }
        };
    }
}

