/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

public class RemovePropertyTest
extends ContextTestSupport {
    private MockEndpoint end;
    private MockEndpoint mid;
    private String propertyName = "foo";
    private String expectedPropertyValue = "bar";

    public void testSetExchangePropertyMidRouteThenRemove() throws Exception {
        this.mid.expectedMessageCount(1);
        this.end.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<blah/>");
        this.assertMockEndpointsSatisfied();
        List midExchanges = this.mid.getExchanges();
        Exchange midExchange = (Exchange)midExchanges.get(0);
        String actualPropertyValue = (String)midExchange.getProperty(this.propertyName, String.class);
        RemovePropertyTest.assertEquals((String)this.expectedPropertyValue, (String)actualPropertyValue);
        List endExchanges = this.end.getExchanges();
        Exchange endExchange = (Exchange)endExchanges.get(0);
        RemovePropertyTest.assertNull((Object)endExchange.getProperty(this.propertyName, String.class));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.end = this.getMockEndpoint("mock:end");
        this.mid = this.getMockEndpoint("mock:mid");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((ProcessorDefinition)this.from("direct:start").setProperty(RemovePropertyTest.this.propertyName).constant((Object)RemovePropertyTest.this.expectedPropertyValue)).to("mock:mid")).removeProperty(RemovePropertyTest.this.propertyName)).to("mock:end");
            }
        };
    }
}

