/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.util.jndi.JndiContext;

public class SimulatorTest
extends ContextTestSupport {
    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("foo", (Object)new MyBean("foo"));
        answer.bind("bar", (Object)new MyBean("bar"));
        return answer;
    }

    public void testReceivesFooResponse() throws Exception {
        this.assertRespondsWith("foo", "Bye said foo");
    }

    public void testReceivesBarResponse() throws Exception {
        this.assertRespondsWith("bar", "Bye said bar");
    }

    protected void assertRespondsWith(final String value, String containedText) throws InvalidPayloadException {
        Exchange response = this.template.request("direct:a", new Processor(){

            public void process(Exchange exchange) throws Exception {
                Message in = exchange.getIn();
                in.setBody((Object)"answer");
                in.setHeader("cheese", (Object)value);
            }
        });
        SimulatorTest.assertNotNull((String)"Should receive a response!", (Object)response);
        String text = (String)response.getOut().getMandatoryBody(String.class);
        SimulatorTest.assertStringContains(text, containedText);
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").recipientList((Expression)this.simple("bean:${in.header.cheese}"));
            }
        };
    }

    public static class MyBean {
        private String value;

        public MyBean(String value) {
            this.value = value;
        }

        public String doSomething(String in) {
            return "Bye said " + this.value;
        }
    }
}

