/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.TimeoutAwareAggregationStrategy;

public class SplitParallelTimeoutTest
extends ContextTestSupport {
    private volatile Exchange receivedExchange;
    private volatile int receivedIndex;
    private volatile int receivedTotal;
    private volatile long receivedTimeout;

    public void testSplitParallelTimeout() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        ((ValueBuilder)mock.message(0).body()).not(SplitParallelTimeoutTest.body().contains((Object)"A"));
        this.template.sendBody("direct:start", (Object)"A,B,C");
        this.assertMockEndpointsSatisfied();
        SplitParallelTimeoutTest.assertNotNull((Object)this.receivedExchange);
        SplitParallelTimeoutTest.assertEquals((int)0, (int)this.receivedIndex);
        SplitParallelTimeoutTest.assertEquals((int)3, (int)this.receivedTotal);
        SplitParallelTimeoutTest.assertEquals((long)1000L, (long)this.receivedTimeout);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").split((Expression)this.body().tokenize(","), (AggregationStrategy)new MyAggregationStrategy()).parallelProcessing().timeout(1000L).choice().when(this.body().isEqualTo((Object)"A")).to("direct:a")).when(this.body().isEqualTo((Object)"B")).to("direct:b")).when(this.body().isEqualTo((Object)"C")).to("direct:c")).end().end().to("mock:result");
                this.from("direct:a").delay(5000L).setBody((Expression)this.constant("A"));
                this.from("direct:b").setBody((Expression)this.constant("B"));
                this.from("direct:c").delay(500L).setBody((Expression)this.constant("C"));
            }
        };
    }

    private class MyAggregationStrategy
    implements TimeoutAwareAggregationStrategy {
        private MyAggregationStrategy() {
        }

        public void timeout(Exchange oldExchange, int index, int total, long timeout) {
            SplitParallelTimeoutTest.this.receivedExchange = oldExchange;
            SplitParallelTimeoutTest.this.receivedIndex = index;
            SplitParallelTimeoutTest.this.receivedTotal = total;
            SplitParallelTimeoutTest.this.receivedTimeout = timeout;
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String body = (String)oldExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)(body + (String)newExchange.getIn().getBody(String.class)));
            return oldExchange;
        }
    }
}

