/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;

public class SplitterStopOnExceptionTest
extends ContextTestSupport {
    public void testSplitStopOnExceptionOk() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World,Bye World");
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitStopOnExceptionStop() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        try {
            this.template.sendBody("direct:start", (Object)"Hello World,Kaboom,Bye World");
            SplitterStopOnExceptionTest.fail((String)"Should thrown an exception");
        }
        catch (CamelExecutionException e) {
            CamelExchangeException cause = SplitterStopOnExceptionTest.assertIsInstanceOf(CamelExchangeException.class, e.getCause());
            SplitterStopOnExceptionTest.assertTrue((boolean)cause.getMessage().startsWith("Sequential processing failed for number 1. Exchange[Message: Kaboom]"));
            SplitterStopOnExceptionTest.assertEquals((String)"Forced", (String)cause.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)this.from("direct:start").split((Expression)this.body().tokenize(",")).stopOnException().process((Processor)new MyProcessor())).to("mock:split");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            if ("Kaboom".equals(body)) {
                throw new IllegalArgumentException("Forced");
            }
        }
    }
}

