/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.camel.CamelException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.processor.MyAggregationStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;

public class SplitterTest
extends ContextTestSupport {
    public void testSendingAMessageUsingMulticastReceivesItsOwnExchange() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedBodiesReceived(new Object[]{"James", "Guillaume", "Hiram", "Rob"});
        this.template.send("direct:seqential", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody((Object)"James,Guillaume,Hiram,Rob");
                in.setHeader("foo", (Object)"bar");
            }
        });
        this.assertMockEndpointsSatisfied();
        List list = resultEndpoint.getReceivedExchanges();
        for (int i = 0; i < 4; ++i) {
            Exchange exchange = (Exchange)list.get(i);
            Message in = exchange.getIn();
            SplitterTest.assertNotNull((String)"The in message should not be null.", (Object)in);
            SplitterTest.assertProperty(exchange, "CamelSplitIndex", i);
            SplitterTest.assertProperty(exchange, "CamelSplitSize", 4);
        }
    }

    public void testSplitterWithAggregationStrategy() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedBodiesReceived(new Object[]{"James", "Guillaume", "Hiram", "Rob", "Roman"});
        Exchange result = this.template.request("direct:seqential", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody((Object)"James,Guillaume,Hiram,Rob,Roman");
                in.setHeader("foo", (Object)"bar");
            }
        });
        this.assertMockEndpointsSatisfied();
        Message out = result.getOut();
        SplitterTest.assertEquals((Object)"Roman", (Object)out.getBody());
        SplitterTest.assertMessageHeader(out, "foo", "bar");
        SplitterTest.assertProperty(result, "CamelSplitIndex", 4);
    }

    public void testEmptyBody() {
        Exchange result = this.template.request("direct:seqential", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setHeader("foo", (Object)"bar");
            }
        });
        SplitterTest.assertFalse((String)"Should not have out", (boolean)result.hasOut());
    }

    public void testSendingAMessageUsingMulticastReceivesItsOwnExchangeParallel() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsNoDuplicates((Expression)SplitterTest.body());
        resultEndpoint.expectedMessageCount(4);
        this.template.send("direct:parallel", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody((Object)"James,Guillaume,Hiram,Rob");
                in.setHeader("foo", (Object)"bar");
            }
        });
        this.assertMockEndpointsSatisfied();
        List list = resultEndpoint.getReceivedExchanges();
        TreeSet<Integer> numbersFound = new TreeSet<Integer>();
        String[] names = new String[]{"James", "Guillaume", "Hiram", "Rob"};
        for (int i = 0; i < 4; ++i) {
            Exchange exchange = (Exchange)list.get(i);
            Message in = exchange.getIn();
            Integer splitCounter = (Integer)exchange.getProperty("CamelSplitIndex", Integer.class);
            numbersFound.add(splitCounter);
            SplitterTest.assertEquals((Object)names[splitCounter], (Object)in.getBody());
            SplitterTest.assertProperty(exchange, "CamelSplitSize", 4);
        }
        SplitterTest.assertEquals((int)4, (int)numbersFound.size());
    }

    public void testSplitterWithAggregationStrategyParallel() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(5);
        Exchange result = this.template.request("direct:parallel", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody((Object)"James,Guillaume,Hiram,Rob,Roman");
                in.setHeader("foo", (Object)"bar");
            }
        });
        this.assertMockEndpointsSatisfied();
        Message out = result.getOut();
        SplitterTest.assertMessageHeader(out, "foo", "bar");
        SplitterTest.assertEquals((Object)5, (Object)result.getProperty("aggregated", Integer.class));
    }

    public void testSplitterWithAggregationStrategyParallelStreaming() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(5);
        resultEndpoint.expectedBodiesReceivedInAnyOrder(new Object[]{"James", "Guillaume", "Hiram", "Rob", "Roman"});
        Exchange result = this.template.request("direct:parallel-streaming", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody((Object)"James,Guillaume,Hiram,Rob,Roman");
                in.setHeader("foo", (Object)"bar");
            }
        });
        this.assertMockEndpointsSatisfied();
        Message out = result.getOut();
        SplitterTest.assertMessageHeader(out, "foo", "bar");
        SplitterTest.assertEquals((Object)5, (Object)result.getProperty("aggregated", Integer.class));
    }

    public void testSplitterParallelAggregate() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(5);
        resultEndpoint.expectedBodiesReceivedInAnyOrder(new Object[]{"James", "Guillaume", "Hiram", "Rob", "Roman"});
        Exchange result = this.template.request("direct:parallelAggregate", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody((Object)"James,Guillaume,Hiram,Rob,Roman");
                in.setHeader("foo", (Object)"bar");
            }
        });
        this.assertMockEndpointsSatisfied();
        Message out = result.getOut();
        SplitterTest.assertMessageHeader(out, "foo", "bar");
        SplitterTest.assertEquals((Object)5, (Object)result.getProperty("aggregated", Integer.class));
    }

    public void testSplitterWithStreamingAndFileBody() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("/org/apache/camel/processor/simple.txt");
        SplitterTest.assertNotNull((String)"We should find this simple file here.", (Object)url);
        File file = new File(url.getFile());
        this.sendToSplitterWithStreaming(file);
    }

    public void testSplitterWithStreamingAndStringBody() throws Exception {
        this.sendToSplitterWithStreaming("James,Guillaume,Hiram,Rob,Roman");
    }

    public void sendToSplitterWithStreaming(final Object body) throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(5);
        resultEndpoint.expectedHeaderReceived("foo", (Object)"bar");
        this.template.request("direct:streaming", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("foo", (Object)"bar");
            }
        });
        this.assertMockEndpointsSatisfied();
        int size = resultEndpoint.getReceivedExchanges().size();
        for (int i = 0; i < size; ++i) {
            Exchange exchange = (Exchange)resultEndpoint.getReceivedExchanges().get(i);
            SplitterTest.assertEquals((Object)i, (Object)exchange.getProperty("CamelSplitIndex"));
            if (i < size - 1) {
                SplitterTest.assertEquals((Object)Boolean.FALSE, (Object)exchange.getProperty("CamelSplitComplete"));
                SplitterTest.assertNull((Object)exchange.getProperty("CamelSplitSize"));
                continue;
            }
            SplitterTest.assertEquals((Object)Boolean.TRUE, (Object)exchange.getProperty("CamelSplitComplete"));
            SplitterTest.assertEquals((Object)size, (Object)exchange.getProperty("CamelSplitSize"));
        }
    }

    public void testSplitterWithException() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(4);
        resultEndpoint.expectedHeaderReceived("foo", (Object)"bar");
        MockEndpoint failedEndpoint = this.getMockEndpoint("mock:failed");
        failedEndpoint.expectedMessageCount(1);
        failedEndpoint.expectedHeaderReceived("foo", (Object)"bar");
        Exchange result = this.template.request("direct:exception", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody((Object)"James,Guillaume,Hiram,Rob,Exception");
                in.setHeader("foo", (Object)"bar");
            }
        });
        SplitterTest.assertTrue((String)"The result exchange should have a camel exception", (boolean)(result.getException() instanceof CamelException));
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitterWithIterable() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(4);
        resultEndpoint.expectedBodiesReceived(new Object[]{"A", "B", "C", "D"});
        final List<String> data = Arrays.asList("A", "B", "C", "D");
        Iterable<String> itb = new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return data.iterator();
            }
        };
        this.sendBody("direct:simple", itb);
        resultEndpoint.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(CamelException.class).to("mock:failed");
                this.from("direct:seqential").split((Expression)this.body().tokenize(","), (AggregationStrategy)new UseLatestAggregationStrategy()).to("mock:result");
                this.from("direct:parallel").split((Expression)this.body().tokenize(","), (AggregationStrategy)new MyAggregationStrategy()).parallelProcessing().to("mock:result");
                this.from("direct:parallelAggregate").split((Expression)this.body().tokenize(","), (AggregationStrategy)new MyAggregationStrategy()).parallelProcessing().parallelAggregate().to("mock:result");
                this.from("direct:streaming").split((Expression)this.body().tokenize(",")).streaming().to("mock:result");
                this.from("direct:parallel-streaming").split((Expression)this.body().tokenize(","), (AggregationStrategy)new MyAggregationStrategy()).parallelProcessing().streaming().to("mock:result");
                ((ExpressionNode)this.from("direct:exception").split((Expression)this.body().tokenize(",")).aggregationStrategy((AggregationStrategy)new MyAggregationStrategy()).parallelProcessing().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String string = (String)exchange.getIn().getBody(String.class);
                        if ("Exception".equals(string)) {
                            throw new CamelException("Just want to throw exception here");
                        }
                    }
                })).to("mock:result");
                this.from("direct:simple").split((Expression)this.body()).to("mock:result");
            }
        };
    }
}

