/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.spi.StreamCachingStrategy;

public class StreamCachingCustomShouldSpoolRuleTest
extends ContextTestSupport {
    private MyCustomSpoolRule spoolRule = new MyCustomSpoolRule();

    @Override
    protected void setUp() throws Exception {
        StreamCachingCustomShouldSpoolRuleTest.deleteDirectory("target/cachedir");
        super.setUp();
    }

    public void testByteArrayInputStream() throws Exception {
        this.getMockEndpoint("mock:english").expectedBodiesReceived(new Object[]{"<hello/>"});
        this.getMockEndpoint("mock:dutch").expectedBodiesReceived(new Object[]{"<hallo/>"});
        this.getMockEndpoint("mock:german").expectedBodiesReceived(new Object[]{"<hallo/>"});
        this.getMockEndpoint("mock:french").expectedBodiesReceived(new Object[]{"<hellos/>"});
        this.template.sendBody("direct:a", (Object)new MyInputStream(new ByteArrayInputStream("<hello/>".getBytes())));
        this.spoolRule.setSpool(true);
        this.template.sendBody("direct:a", (Object)new MyInputStream(new ByteArrayInputStream("<hallo/>".getBytes())));
        this.template.sendBody("direct:a", (Object)new MyInputStream(new ByteArrayInputStream("<hellos/>".getBytes())));
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                StreamCachingCustomShouldSpoolRuleTest.this.context.getStreamCachingStrategy().setSpoolDirectory("target/cachedir");
                StreamCachingCustomShouldSpoolRuleTest.this.context.getStreamCachingStrategy().addSpoolRule((StreamCachingStrategy.SpoolRule)StreamCachingCustomShouldSpoolRuleTest.this.spoolRule);
                StreamCachingCustomShouldSpoolRuleTest.this.context.getStreamCachingStrategy().setAnySpoolRules(true);
                StreamCachingCustomShouldSpoolRuleTest.this.context.setStreamCaching(Boolean.valueOf(true));
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:a").choice().when((Predicate)this.xpath("//hello")).to("mock:english")).when((Predicate)this.xpath("//hallo")).to(new String[]{"mock:dutch", "mock:german"})).otherwise().to("mock:french")).end().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        if (StreamCachingCustomShouldSpoolRuleTest.this.spoolRule.isSpool()) {
                            String[] names = new File("target/cachedir").list();
                            TestCase.assertEquals((String)"There should be a cached spool file", (int)1, (int)names.length);
                        }
                    }
                });
            }
        };
    }

    private static final class MyCustomSpoolRule
    implements StreamCachingStrategy.SpoolRule {
        private volatile boolean spool;

        private MyCustomSpoolRule() {
        }

        public boolean shouldSpoolCache(long length) {
            return this.spool;
        }

        public boolean isSpool() {
            return this.spool;
        }

        public void setSpool(boolean spool) {
            this.spool = spool;
        }

        public String toString() {
            return "MyCustomSpoolRule";
        }
    }

    private final class MyInputStream
    extends FilterInputStream {
        private MyInputStream(InputStream in) {
            super(in);
        }
    }
}

