/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class ThrottlerAsyncDelayedTest
extends ContextTestSupport {
    private static final int INTERVAL = 500;
    protected int messageCount = 9;

    public void testSendLotsOfMessagesButOnly3GetThrough() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(3);
        resultEndpoint.setResultWaitTime(5000L);
        for (int i = 0; i < this.messageCount; ++i) {
            this.template.sendBody("seda:a", (Object)("<message>" + i + "</message>"));
        }
        resultEndpoint.assertIsSatisfied();
    }

    public void testSendLotsOfMessagesSimultaneouslyButOnly3GetThrough() throws Exception {
        long start = System.currentTimeMillis();
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(this.messageCount);
        ExecutorService executor = Executors.newFixedThreadPool(this.messageCount);
        for (int i = 0; i < this.messageCount; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ThrottlerAsyncDelayedTest.this.template.sendBody("direct:a", (Object)"<message>payload</message>");
                }
            });
        }
        resultEndpoint.assertIsSatisfied();
        long minimumTime = (this.messageCount - 1) * 500;
        long delta = System.currentTimeMillis() - start + 200L;
        ThrottlerAsyncDelayedTest.assertTrue((String)("Should take at least " + minimumTime + "ms, was: " + delta), (delta >= minimumTime ? 1 : 0) != 0);
        executor.shutdownNow();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:a").throttle(3L).timePeriodMillis(10000L).asyncDelayed().to(new String[]{"log:result", "mock:result"});
                this.from("direct:a").throttle(1L).timePeriodMillis(500L).asyncDelayed().to(new String[]{"log:result", "mock:result"});
            }
        };
    }
}

