/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;

public class TryProcessorHandleWrappedExceptionTest
extends ContextTestSupport {
    private boolean handled;

    public void testTryCatchFinally() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        this.getMockEndpoint("mock:finally").expectedMessageCount(1);
        this.sendBody("direct:start", "<test>Hello World!</test>");
        TryProcessorHandleWrappedExceptionTest.assertTrue((String)"Should have been handled", (boolean)this.handled);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().process((Processor)new ProcessorFail())).to("mock:result")).doCatch(IllegalStateException.class).process((Processor)new ProcessorHandle())).doFinally().to("mock:finally")).end();
            }
        };
    }

    private class ProcessorHandle
    implements Processor {
        private ProcessorHandle() {
        }

        public void process(Exchange exchange) throws Exception {
            TryProcessorHandleWrappedExceptionTest.this.handled = true;
            TestCase.assertEquals((String)"Should not be marked as failed", (boolean)false, (boolean)exchange.isFailed());
            Exception e = (Exception)exchange.getProperty("CamelExceptionCaught");
            TestCase.assertNotNull((String)"There should be an exception", (Object)e);
            TestCase.assertTrue((boolean)(e instanceof IllegalStateException));
            TestCase.assertEquals((String)"Force to fail", (String)e.getMessage());
        }
    }

    private class ProcessorFail
    implements Processor {
        private ProcessorFail() {
        }

        public void process(Exchange exchange) throws Exception {
            throw new IllegalStateException("Force to fail");
        }
    }
}

