/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.CamelException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;

public class TryProcessorTest
extends ContextTestSupport {
    private boolean handled;

    public void testTryCatchFinallyProcessor() throws Exception {
        this.testTryCatchFinally("direct:processor");
    }

    public void testTryCatchFinallyExpression() throws Exception {
        this.testTryCatchFinally("direct:expression");
    }

    public void testTryCatchFinallyPredicate() throws Exception {
        this.testTryCatchFinally("direct:predicate");
    }

    private void testTryCatchFinally(String endpointName) throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        this.getMockEndpoint("mock:last").expectedMessageCount(1);
        this.getMockEndpoint("mock:finally").expectedMessageCount(1);
        this.sendBody(endpointName, "<test>Hello World!</test>");
        TryProcessorTest.assertTrue((String)"Should have been handled", (boolean)this.handled);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:processor").doTry().process((Processor)new ProcessorFail())).to("mock:result")).doCatch(CamelException.class).process((Processor)new ProcessorHandle())).doFinally().to("mock:finally")).end().to("mock:last");
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:expression").doTry().setBody((Expression)new ProcessorFail())).to("mock:result")).doCatch(CamelException.class).process((Processor)new ProcessorHandle())).doFinally().to("mock:finally")).end().to("mock:last");
                ((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:predicate").doTry().to("direct:sub-predicate")).doCatch(CamelException.class).process((Processor)new ProcessorHandle())).doFinally().to("mock:finally")).end().to("mock:last");
                this.from("direct:sub-predicate").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).filter((Predicate)new ProcessorFail()).to("mock:result");
            }
        };
    }

    private class ProcessorHandle
    implements Processor {
        private ProcessorHandle() {
        }

        public void process(Exchange exchange) throws Exception {
            TryProcessorTest.this.handled = true;
            TestCase.assertEquals((String)"Should not be marked as failed", (boolean)false, (boolean)exchange.isFailed());
            Exception e = (Exception)exchange.getProperty("CamelExceptionCaught");
            TestCase.assertNotNull((String)"There should be an exception", (Object)e);
            CamelException cause = TestSupport.assertIsInstanceOf(CamelException.class, e.getCause());
            TestCase.assertNotNull((Object)cause);
            TestCase.assertEquals((String)"Force to fail", (String)cause.getMessage());
        }
    }

    private class ProcessorFail
    implements Processor,
    Predicate,
    Expression {
        private ProcessorFail() {
        }

        public void process(Exchange exchange) throws Exception {
            throw new RuntimeCamelException((Throwable)new CamelException("Force to fail"));
        }

        public <T> T evaluate(Exchange exchange, Class<T> type) {
            throw new RuntimeCamelException((Throwable)new CamelException("Force to fail"));
        }

        public boolean matches(Exchange exchange) {
            throw new RuntimeCamelException((Throwable)new CamelException("Force to fail"));
        }
    }
}

