/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ValidateDefinition;
import org.apache.camel.processor.validation.PredicateValidationException;

public class ValidateSimpleTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start", Endpoint.class);
        this.resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
    }

    public void testSendMatchingMessage() throws Exception {
        this.resultEndpoint.expectedMessageCount(1);
        this.template.sendBody(this.startEndpoint, (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendNotMatchingMessage() throws Exception {
        this.resultEndpoint.expectedMessageCount(0);
        try {
            this.template.sendBody(this.startEndpoint, (Object)"Bye World");
            ValidateSimpleTest.fail((String)"CamelExecutionException expected");
        }
        catch (CamelExecutionException e) {
            ValidateSimpleTest.assertIsInstanceOf(PredicateValidationException.class, e.getCause());
            ValidateSimpleTest.assertEquals((String)"Validation failed for Predicate[Simple: ${body} contains 'Camel']. Exchange[Message: Bye World]", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ValidateDefinition)this.from("direct:start").validate().simple("${body} contains 'Camel'")).to("mock:result");
            }
        };
    }
}

