/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.ValidatingProcessorTest;
import org.apache.camel.processor.validation.NoXmlBodyValidationException;

public class ValidatingDomProcessorTest
extends ValidatingProcessorTest {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.validating.setUseDom(true);
        ValidatingDomProcessorTest.assertEquals((boolean)true, (boolean)this.validating.isUseDom());
    }

    @Override
    public void testNonWellFormedXml() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:invalid");
        mock.expectedMessageCount(1);
        String xml = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>user xmlns=\"http://foo.com/bar\">  <id>1</id>  <username>davsclaus</username>";
        try {
            this.template.sendBody("direct:start", (Object)xml);
            ValidatingDomProcessorTest.fail((String)"Should have thrown a RuntimeCamelException");
        }
        catch (CamelExecutionException e) {
            ValidatingDomProcessorTest.assertIsInstanceOf(NoXmlBodyValidationException.class, e.getCause());
        }
        this.assertMockEndpointsSatisfied();
    }
}

