/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class AggregateFromWireTapTest
extends ContextTestSupport {
    public void testAggregateFromWireTap() throws Exception {
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedBodiesReceived(new Object[]{"A", "B"});
        MockEndpoint aggregated = this.getMockEndpoint("mock:aggregated");
        aggregated.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBody("direct:start", (Object)"B");
        this.assertMockEndpointsSatisfied();
        String body = (String)((Exchange)aggregated.getReceivedExchanges().get(0)).getIn().getBody(String.class);
        AggregateFromWireTapTest.assertTrue((String)("Should be AB or BA, was: " + body), ("AB".equals(body) || "BA".equals(body) ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AggregateFromWireTapTest.this.context.setTracing(Boolean.valueOf(true));
                this.from("direct:start").wireTap("direct:tap").to("mock:end");
                ((AggregateDefinition)this.from("direct:tap").aggregate((Expression)this.constant(true), (AggregationStrategy)new MyAggregationStrategy()).completionSize(2).completionTimeout(5000L).to("direct:aggregated")).end();
                this.from("direct:aggregated").to("mock:aggregated");
            }
        };
    }

    public static class MyAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String oldBody = (String)oldExchange.getIn().getBody(String.class);
            String newBody = (String)newExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)(oldBody + newBody));
            return oldExchange;
        }
    }
}

