/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.spi.AggregationRepository;

public class AggregateNewExchangeAndConfirmTest
extends ContextTestSupport {
    private MyRepo repo = new MyRepo();

    public void testAggregateNewExchangeAndConfirm() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:aggregated");
        mock.expectedBodiesReceived(new Object[]{"ABC"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)123);
        this.assertMockEndpointsSatisfied();
        Thread.sleep(500L);
        AggregateNewExchangeAndConfirmTest.assertEquals((String)((Exchange)mock.getReceivedExchanges().get(0)).getExchangeId(), (String)this.repo.getId());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new MyNewExchangeAggregationStrategy()).aggregationRepository((AggregationRepository)AggregateNewExchangeAndConfirmTest.this.repo).completionSize(3).to("mock:aggregated");
            }
        };
    }

    private class MyRepo
    extends MemoryAggregationRepository {
        private String id;

        private MyRepo() {
        }

        public void confirm(CamelContext camelContext, String exchangeId) {
            AggregateNewExchangeAndConfirmTest.this.log.info("Confirmed id: " + exchangeId);
            this.id = exchangeId;
        }

        public String getId() {
            return this.id;
        }
    }

    private class MyNewExchangeAggregationStrategy
    implements AggregationStrategy {
        private MyNewExchangeAggregationStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            String body = "";
            if (oldExchange != null) {
                body = (String)oldExchange.getIn().getBody(String.class);
            }
            body = body + (String)newExchange.getIn().getBody(String.class);
            newExchange.getIn().setBody((Object)body);
            return newExchange;
        }
    }
}

