/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.spi.AggregationRepository;

public class BeanBeforeAggregateIssueTest
extends ContextTestSupport {
    private MyAggRepo myRepo = new MyAggRepo();

    public void testBeanBeforeAggregation() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(3).create();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A+B"});
        this.template.sendBody("seda:start", (Object)"A");
        this.template.sendBody("seda:start", (Object)"B");
        this.assertMockEndpointsSatisfied();
        notify.matches(5L, TimeUnit.SECONDS);
        BeanBeforeAggregateIssueTest.assertTrue((String)"Should have confirmed", (boolean)this.myRepo.isConfirm());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:start").bean(TestBean.class)).aggregate((Expression)this.constant("true"), (AggregationStrategy)new BodyInAggregatingStrategy()).aggregationRepository((AggregationRepository)BeanBeforeAggregateIssueTest.this.myRepo).completionSize(2).to("mock:result");
            }
        };
    }

    private static final class MyAggRepo
    extends MemoryAggregationRepository {
        private volatile boolean confirm;

        private MyAggRepo() {
        }

        public void confirm(CamelContext camelContext, String exchangeId) {
            super.confirm(camelContext, exchangeId);
            this.confirm = true;
        }

        public boolean isConfirm() {
            return this.confirm;
        }
    }

    public static final class TestBean {
        public String doNothing(String foo) {
            return foo;
        }
    }
}

