/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class CustomAggregationStrategyTest
extends ContextTestSupport {
    public void testCustomAggregationStrategy() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceivedInAnyOrder(new Object[]{"200", "150"});
        this.template.sendBodyAndHeader("direct:start", (Object)"100", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"150", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"130", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"200", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"190", "id", (Object)"1");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((AggregateDefinition)this.from("direct:start").aggregate((AggregationStrategy)new MyAggregationStrategy()).header("id")).completionTimeout(1000L).to("mock:result");
            }
        };
    }

    private static class MyAggregationStrategy
    implements AggregationStrategy {
        private MyAggregationStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            int oldPrice = (Integer)oldExchange.getIn().getBody(Integer.class);
            int newPrice = (Integer)newExchange.getIn().getBody(Integer.class);
            return newPrice > oldPrice ? newExchange : oldExchange;
        }
    }
}

