/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.async.MyAsyncComponent;

public class AsyncEndpointDynamicRouterTest
extends ContextTestSupport {
    private static int invoked;
    private static List<String> bodies;

    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        AsyncEndpointDynamicRouterTest.assertEquals((String)"Bye World", (String)reply);
        this.assertMockEndpointsSatisfied();
        AsyncEndpointDynamicRouterTest.assertEquals((int)4, (int)invoked);
        AsyncEndpointDynamicRouterTest.assertEquals((int)4, (int)bodies.size());
        AsyncEndpointDynamicRouterTest.assertEquals((String)"Hello Camel", (String)bodies.get(0));
        AsyncEndpointDynamicRouterTest.assertEquals((String)"Bye Camel", (String)bodies.get(1));
        AsyncEndpointDynamicRouterTest.assertEquals((String)"Bye World", (String)bodies.get(2));
        AsyncEndpointDynamicRouterTest.assertEquals((String)"Bye World", (String)bodies.get(3));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointDynamicRouterTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                this.from("direct:start").dynamicRouter((Expression)this.method(AsyncEndpointDynamicRouterTest.class, "slip"));
                this.from("direct:foo").transform((Expression)this.constant("Bye World"));
            }
        };
    }

    public String slip(String body) {
        bodies.add(body);
        if (++invoked == 1) {
            return "async:bye:camel";
        }
        if (invoked == 2) {
            return "direct:foo";
        }
        if (invoked == 3) {
            return "mock:result";
        }
        return null;
    }

    static {
        bodies = new ArrayList<String>();
    }
}

