/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;

public class AsyncEndpointRecipientList4Test
extends ContextTestSupport {
    private static long beforeThreadId;
    private static long afterThreadId;

    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        AsyncEndpointRecipientList4Test.assertEquals((String)"Bye Camel", (String)reply);
        this.assertMockEndpointsSatisfied();
        AsyncEndpointRecipientList4Test.assertTrue((String)("Should use different threads " + beforeThreadId + ":" + afterThreadId), (beforeThreadId != afterThreadId ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointRecipientList4Test.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:before")).to("log:before")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        beforeThreadId = Thread.currentThread().getId();
                    }
                })).recipientList((Expression)this.constant("async:hi:camel,async:hi:world,direct:foo"));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:foo").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        afterThreadId = Thread.currentThread().getId();
                        exchange.getOut().setBody((Object)"Bye Camel");
                    }
                })).to("log:after")).to("mock:after")).to("mock:result");
            }
        };
    }
}

