/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.Collection;
import java.util.concurrent.RejectedExecutionException;
import junit.framework.TestCase;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.AsyncProcessorAwaitManager;

public class AsyncProcessorAwaitManagerInterruptTest
extends ContextTestSupport {
    public void testAsyncAwaitInterrupt() throws Exception {
        this.context.getAsyncProcessorAwaitManager().getStatistics().setStatisticsEnabled(true);
        AsyncProcessorAwaitManagerInterruptTest.assertEquals((int)0, (int)this.context.getAsyncProcessorAwaitManager().size());
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
            AsyncProcessorAwaitManagerInterruptTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            RejectedExecutionException cause = AsyncProcessorAwaitManagerInterruptTest.assertIsInstanceOf(RejectedExecutionException.class, e.getCause());
            AsyncProcessorAwaitManagerInterruptTest.assertTrue((boolean)cause.getMessage().startsWith("Interrupted while waiting for asynchronous callback"));
        }
        this.assertMockEndpointsSatisfied();
        AsyncProcessorAwaitManagerInterruptTest.assertEquals((int)0, (int)this.context.getAsyncProcessorAwaitManager().size());
        AsyncProcessorAwaitManagerInterruptTest.assertEquals((long)1L, (long)this.context.getAsyncProcessorAwaitManager().getStatistics().getThreadsBlocked());
        AsyncProcessorAwaitManagerInterruptTest.assertEquals((long)1L, (long)this.context.getAsyncProcessorAwaitManager().getStatistics().getThreadsInterrupted());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncProcessorAwaitManagerInterruptTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("myRoute").to("mock:before")).to("async:bye:camel?delay=1000")).id("myAsync")).to("mock:after")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        int size = AsyncProcessorAwaitManagerInterruptTest.this.context.getAsyncProcessorAwaitManager().size();
                        log.info("async inflight: {}", (Object)size);
                        TestCase.assertEquals((int)1, (int)size);
                        Collection threads = AsyncProcessorAwaitManagerInterruptTest.this.context.getAsyncProcessorAwaitManager().browse();
                        AsyncProcessorAwaitManager.AwaitThread thread = (AsyncProcessorAwaitManager.AwaitThread)threads.iterator().next();
                        String id = thread.getExchange().getExchangeId();
                        AsyncProcessorAwaitManagerInterruptTest.this.context.getAsyncProcessorAwaitManager().interrupt(id);
                    }
                })).transform((Expression)this.constant("Hi Camel"))).to("mock:result");
            }
        };
    }
}

