/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.Collection;
import junit.framework.TestCase;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.AsyncProcessorAwaitManager;

public class AsyncProcessorAwaitManagerTest
extends ContextTestSupport {
    public void testAsyncAwait() throws Exception {
        this.context.getAsyncProcessorAwaitManager().getStatistics().setStatisticsEnabled(true);
        AsyncProcessorAwaitManagerTest.assertEquals((int)0, (int)this.context.getAsyncProcessorAwaitManager().size());
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        AsyncProcessorAwaitManagerTest.assertEquals((String)"Bye Camel", (String)reply);
        this.assertMockEndpointsSatisfied();
        AsyncProcessorAwaitManagerTest.assertEquals((int)0, (int)this.context.getAsyncProcessorAwaitManager().size());
        AsyncProcessorAwaitManagerTest.assertEquals((long)1L, (long)this.context.getAsyncProcessorAwaitManager().getStatistics().getThreadsBlocked());
        AsyncProcessorAwaitManagerTest.assertEquals((long)0L, (long)this.context.getAsyncProcessorAwaitManager().getStatistics().getThreadsInterrupted());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncProcessorAwaitManagerTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("myRoute").to("mock:before")).to("async:bye:camel")).id("myAsync")).to("mock:after")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        int size = AsyncProcessorAwaitManagerTest.this.context.getAsyncProcessorAwaitManager().size();
                        log.info("async inflight: {}", (Object)size);
                        TestCase.assertEquals((int)1, (int)size);
                        Collection threads = AsyncProcessorAwaitManagerTest.this.context.getAsyncProcessorAwaitManager().browse();
                        AsyncProcessorAwaitManager.AwaitThread thread = (AsyncProcessorAwaitManager.AwaitThread)threads.iterator().next();
                        long wait = thread.getWaitDuration();
                        log.info("Thread {} has waited for {} msec.", (Object)thread.getBlockedThread().getName(), (Object)wait);
                        TestCase.assertEquals((String)"myRoute", (String)thread.getRouteId());
                        TestCase.assertEquals((String)"myAsync", (String)thread.getNodeId());
                    }
                })).to("mock:result");
            }
        };
    }
}

