/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.TraceEventMessage;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;

public class InterceptSimpleRouteTraceTest
extends ContextTestSupport {
    public void testIntercept() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:intercepted").expectedMessageCount(3);
        this.getMockEndpoint("mock:trace").expectedMessageCount(6);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        TraceEventMessage msg1 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(0)).getIn().getBody(TraceEventMessage.class);
        TraceEventMessage msg2 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(1)).getIn().getBody(TraceEventMessage.class);
        TraceEventMessage msg3 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(2)).getIn().getBody(TraceEventMessage.class);
        TraceEventMessage msg4 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(3)).getIn().getBody(TraceEventMessage.class);
        TraceEventMessage msg5 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(4)).getIn().getBody(TraceEventMessage.class);
        TraceEventMessage msg6 = (TraceEventMessage)((Exchange)this.getMockEndpoint("mock:trace").getReceivedExchanges().get(5)).getIn().getBody(TraceEventMessage.class);
        InterceptSimpleRouteTraceTest.assertEquals((String)"direct://start", (String)msg1.getFromEndpointUri());
        InterceptSimpleRouteTraceTest.assertEquals((String)"mock://intercepted", (String)msg1.getToNode());
        InterceptSimpleRouteTraceTest.assertEquals((String)"mock://intercepted", (String)msg2.getPreviousNode());
        InterceptSimpleRouteTraceTest.assertEquals((String)"mock://foo", (String)msg2.getToNode());
        InterceptSimpleRouteTraceTest.assertEquals((String)"mock://foo", (String)msg3.getPreviousNode());
        InterceptSimpleRouteTraceTest.assertEquals((String)"mock://intercepted", (String)msg3.getToNode());
        InterceptSimpleRouteTraceTest.assertEquals((String)"mock://intercepted", (String)msg4.getPreviousNode());
        InterceptSimpleRouteTraceTest.assertEquals((String)"mock://bar", (String)msg4.getToNode());
        InterceptSimpleRouteTraceTest.assertEquals((String)"mock://bar", (String)msg5.getPreviousNode());
        InterceptSimpleRouteTraceTest.assertEquals((String)"mock://intercepted", (String)msg5.getToNode());
        InterceptSimpleRouteTraceTest.assertEquals((String)"mock://intercepted", (String)msg6.getPreviousNode());
        InterceptSimpleRouteTraceTest.assertEquals((String)"mock://result", (String)msg6.getToNode());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                Tracer tracer = new Tracer();
                tracer.setDestinationUri("mock:trace");
                InterceptSimpleRouteTraceTest.this.context.addInterceptStrategy((InterceptStrategy)tracer);
                this.intercept().to("mock:intercepted");
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).to("mock:bar")).to("mock:result");
            }
        };
    }
}

