/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class AdviceWithMockEndpointsHavingParameterTest
extends ContextTestSupport {
    public void testNoAdvised() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testAdvisedMockEndpoints() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(1)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.mockEndpoints();
            }
        });
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:direct:start").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:log:start").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:seda:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        AdviceWithMockEndpointsHavingParameterTest.assertNotNull((Object)this.context.hasEndpoint("direct:start"));
        AdviceWithMockEndpointsHavingParameterTest.assertNotNull((Object)this.context.hasEndpoint("seda:foo"));
        AdviceWithMockEndpointsHavingParameterTest.assertNotNull((Object)this.context.hasEndpoint("log:foo?showHeaders=false"));
        AdviceWithMockEndpointsHavingParameterTest.assertNotNull((Object)this.context.hasEndpoint("log:start?showAll=true"));
        AdviceWithMockEndpointsHavingParameterTest.assertNotNull((Object)this.context.hasEndpoint("mock:result"));
        AdviceWithMockEndpointsHavingParameterTest.assertNotNull((Object)this.context.hasEndpoint("mock:direct:start"));
        AdviceWithMockEndpointsHavingParameterTest.assertNotNull((Object)this.context.hasEndpoint("mock:seda:foo"));
        AdviceWithMockEndpointsHavingParameterTest.assertNotNull((Object)this.context.hasEndpoint("mock:log:start"));
        AdviceWithMockEndpointsHavingParameterTest.assertNotNull((Object)this.context.hasEndpoint("mock:log:foo"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:foo?size=20").transform((Expression)this.constant("Bye World"))).log("We transformed ${body}")).to("log:foo?showHeaders=false")).to("mock:foo");
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("seda:foo")).to("log:start?showAll=true")).to("mock:result");
            }
        };
    }
}

