/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class AdviceWithTwoRoutesOnExceptionTest
extends ContextTestSupport {
    public void testAdviceWithA() throws Exception {
        RouteDefinition route = this.context.getRouteDefinition("a");
        route.adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("mock://a").skipSendToOriginalEndpoint().throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        this.getMockEndpoint("mock:a").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:error").message(0).exchangeProperty("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testAdviceWithB() throws Exception {
        RouteDefinition route = this.context.getRouteDefinition("b");
        route.adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("mock://b").skipSendToOriginalEndpoint().throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:error").message(0).exchangeProperty("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.template.sendBody("direct:b", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testAdviceWithAB() throws Exception {
        RouteDefinition route = this.context.getRouteDefinition("a");
        route.adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("mock://a").skipSendToOriginalEndpoint().throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        route = this.context.getRouteDefinition("b");
        route.adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("mock://b").skipSendToOriginalEndpoint().throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        this.getMockEndpoint("mock:a").expectedMessageCount(0);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(2);
        ((ValueBuilder)this.getMockEndpoint("mock:error").message(0).exchangeProperty("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        ((ValueBuilder)this.getMockEndpoint("mock:error").message(1).exchangeProperty("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.template.sendBody("direct:b", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.from("direct:a").routeId("a").onException(Exception.class).handled(true).to("mock:error")).end().to("log:a").to("mock:a");
                ((OnExceptionDefinition)this.from("direct:b").routeId("b").onException(Exception.class).handled(true).to("mock:error")).end().to("log:b").to("mock:b");
            }
        };
    }
}

