/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.spi.InterceptStrategy;

public class AuditInterceptorDelegateIssueTest
extends ContextTestSupport {
    private MyIntercepStrategy strategy;

    @Override
    protected void setUp() throws Exception {
        this.strategy = new MyIntercepStrategy();
        super.setUp();
    }

    public void testOk() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        AuditInterceptorDelegateIssueTest.assertEquals((boolean)true, (boolean)this.strategy.isInvoked());
    }

    public void testILE() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:handled").expectedMessageCount(1);
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.template.sendBody("direct:iae", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        AuditInterceptorDelegateIssueTest.assertEquals((boolean)true, (boolean)this.strategy.isInvoked());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.getContext().addInterceptStrategy((InterceptStrategy)AuditInterceptorDelegateIssueTest.this.strategy);
                this.onException(IllegalArgumentException.class).handled(true).to("mock:handled");
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead").maximumRedeliveries(1));
                this.from("direct:start").to("mock:result");
                this.from("direct:iae").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }

    private static final class MyIntercepStrategy
    implements InterceptStrategy {
        private volatile boolean invoked;

        private MyIntercepStrategy() {
        }

        public Processor wrapProcessorInInterceptors(CamelContext context, ProcessorDefinition<?> definition, Processor target, Processor nextTarget) throws Exception {
            return new DelegateProcessor(target){

                protected void processNext(Exchange exchange) throws Exception {
                    MyIntercepStrategy.this.invoked = true;
                    super.processNext(exchange);
                }
            };
        }

        public boolean isInvoked() {
            return this.invoked;
        }
    }
}

