/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.BreakpointSupport;
import org.apache.camel.impl.ConditionSupport;
import org.apache.camel.impl.DefaultDebugger;
import org.apache.camel.management.event.ExchangeCompletedEvent;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.Condition;
import org.apache.camel.spi.Debugger;

public class DebugTest
extends ContextTestSupport {
    private List<String> logs = new ArrayList<String>();
    private Condition camelCondition;
    private Condition mockCondition;
    private Condition doneCondition;
    private Breakpoint breakpoint;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.breakpoint = new BreakpointSupport(){

            public void beforeProcess(Exchange exchange, Processor processor, ProcessorDefinition<?> definition) {
                String body = (String)exchange.getIn().getBody(String.class);
                DebugTest.this.logs.add("Breakpoint at " + definition + " with body: " + body);
            }

            public void onEvent(Exchange exchange, EventObject event, ProcessorDefinition<?> definition) {
                String body = (String)exchange.getIn().getBody(String.class);
                DebugTest.this.logs.add("Breakpoint event " + event.getClass().getSimpleName() + " with body: " + body);
            }
        };
        this.camelCondition = new ConditionSupport(){

            public boolean matchProcess(Exchange exchange, Processor processor, ProcessorDefinition<?> definition) {
                return TestSupport.body().contains((Object)"Camel").matches(exchange);
            }
        };
        this.mockCondition = new ConditionSupport(){

            public boolean matchProcess(Exchange exchange, Processor processor, ProcessorDefinition<?> definition) {
                if (definition instanceof ToDefinition) {
                    ToDefinition to = (ToDefinition)definition;
                    return to.getUriOrRef().startsWith("mock");
                }
                return false;
            }
        };
        this.doneCondition = new ConditionSupport(){

            public boolean matchEvent(Exchange exchange, EventObject event) {
                return event instanceof ExchangeCompletedEvent;
            }
        };
    }

    public void testDebug() throws Exception {
        this.context.getDebugger().addBreakpoint(this.breakpoint, new Condition[]{this.camelCondition});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Hello Camel"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        DebugTest.assertEquals((int)2, (int)this.logs.size());
        DebugTest.assertEquals((String)"Breakpoint at To[log:foo] with body: Hello Camel", (String)this.logs.get(0));
        DebugTest.assertEquals((String)"Breakpoint at To[mock:result] with body: Hello Camel", (String)this.logs.get(1));
    }

    public void testDebugEvent() throws Exception {
        this.context.getDebugger().addBreakpoint(this.breakpoint, new Condition[]{this.doneCondition});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Hello Camel"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        DebugTest.assertEquals((int)2, (int)this.logs.size());
        DebugTest.assertEquals((String)"Breakpoint event ExchangeCompletedEvent with body: Hello World", (String)this.logs.get(0));
        DebugTest.assertEquals((String)"Breakpoint event ExchangeCompletedEvent with body: Hello Camel", (String)this.logs.get(1));
    }

    public void testDebugSuspended() throws Exception {
        this.context.getDebugger().addBreakpoint(this.breakpoint, new Condition[]{this.mockCondition, this.camelCondition});
        this.context.getDebugger().suspendAllBreakpoints();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Hello Camel"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        DebugTest.assertEquals((int)0, (int)this.logs.size());
        this.context.getDebugger().activateAllBreakpoints();
        this.resetMocks();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Hello Camel"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        DebugTest.assertEquals((int)1, (int)this.logs.size());
        DebugTest.assertEquals((String)"Breakpoint at To[mock:result] with body: Hello Camel", (String)this.logs.get(0));
    }

    public void testDebugRemoveBreakpoint() throws Exception {
        this.context.getDebugger().addBreakpoint(this.breakpoint);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        DebugTest.assertEquals((int)10, (int)this.logs.size());
        this.context.getDebugger().removeBreakpoint(this.breakpoint);
        this.resetMocks();
        this.logs.clear();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
        DebugTest.assertEquals((int)0, (int)this.logs.size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                DebugTest.this.context.setDebugger((Debugger)new DefaultDebugger());
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

