/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Ordered;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.InterceptStrategy;

public class InterceptorStrategyOrderedTest
extends ContextTestSupport {
    public void testInterceptorStrategyOrdered() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedHeaderReceived("order", (Object)"12");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                InterceptorStrategyOrderedTest.this.context.addInterceptStrategy((InterceptStrategy)new BarInterceptStrategy());
                InterceptorStrategyOrderedTest.this.context.addInterceptStrategy((InterceptStrategy)new FooInterceptStrategy());
                this.from("direct:start").to("mock:result");
            }
        };
    }

    public static class BarInterceptStrategy
    implements InterceptStrategy,
    Ordered {
        public Processor wrapProcessorInInterceptors(CamelContext context, ProcessorDefinition<?> definition, final Processor target, Processor nextTarget) throws Exception {
            Processor answer = new Processor(){

                public void process(Exchange exchange) throws Exception {
                    String order = (String)exchange.getIn().getHeader("order", (Object)"", String.class);
                    order = order + BarInterceptStrategy.this.getOrder();
                    exchange.getIn().setHeader("order", (Object)order);
                    target.process(exchange);
                }
            };
            return answer;
        }

        public int getOrder() {
            return 2;
        }
    }

    public static class FooInterceptStrategy
    implements InterceptStrategy,
    Ordered {
        public Processor wrapProcessorInInterceptors(CamelContext context, ProcessorDefinition<?> definition, final Processor target, Processor nextTarget) throws Exception {
            Processor answer = new Processor(){

                public void process(Exchange exchange) throws Exception {
                    String order = (String)exchange.getIn().getHeader("order", (Object)"", String.class);
                    order = order + FooInterceptStrategy.this.getOrder();
                    exchange.getIn().setHeader("order", (Object)order);
                    target.process(exchange);
                }
            };
            return answer;
        }

        public int getOrder() {
            return 1;
        }
    }
}

