/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.BytesSource;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.StringSource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.processor.interceptor.StreamCaching;
import org.apache.camel.processor.interceptor.StreamCachingInterceptor;

public class StreamCachingInterceptorTest
extends ContextTestSupport {
    private static final String MESSAGE = "<hello>world!</hello>";
    private static final String BODY_TYPE = "body.type";
    private MockEndpoint a;
    private MockEndpoint b;
    private final XmlConverter converter = new XmlConverter();

    public void testConvertStreamSourceWithRouteBuilderStreamCaching() throws Exception {
        this.a.expectedMessageCount(1);
        StreamSource message = new StreamSource(new StringReader(MESSAGE));
        this.template.sendBody("direct:a", (Object)message);
        this.assertMockEndpointsSatisfied();
        StreamCachingInterceptorTest.assertTrue((boolean)(this.a.assertExchangeReceived(0).getIn().getBody() instanceof StreamCache));
    }

    public void testNoConversionForOtherXmlSourceTypes() throws Exception {
        this.a.expectedMessageCount(3);
        this.send(this.converter.toDOMSource(MESSAGE));
        this.send((Source)new StringSource(MESSAGE));
        this.send((Source)new BytesSource(MESSAGE.getBytes()));
        this.assertMockEndpointsSatisfied();
        for (Exchange exchange : this.a.getExchanges()) {
            StreamCachingInterceptorTest.assertFalse((String)(((Class)exchange.getIn().getHeader(BODY_TYPE, Class.class)).toString() + " shouldn't have been converted to StreamCache"), (boolean)(exchange.getIn().getBody() instanceof StreamCache));
        }
    }

    private void send(Source source) {
        this.template.sendBodyAndHeader("direct:a", (Object)source, BODY_TYPE, source.getClass());
    }

    public void testConvertStreamSourceWithRouteOnlyStreamCaching() throws Exception {
        this.b.expectedMessageCount(1);
        StreamSource message = new StreamSource(new StringReader(MESSAGE));
        this.template.sendBody("direct:b", (Object)message);
        this.assertMockEndpointsSatisfied();
        StreamCachingInterceptorTest.assertTrue((boolean)(this.b.assertExchangeReceived(0).getIn().getBody() instanceof StreamCache));
        StreamCachingInterceptorTest.assertEquals((String)((String)this.b.assertExchangeReceived(0).getIn().getBody(String.class)), (String)MESSAGE);
    }

    public void testConvertInputStreamWithRouteBuilderStreamCaching() throws Exception {
        this.a.expectedMessageCount(1);
        ByteArrayInputStream message = new ByteArrayInputStream(MESSAGE.getBytes());
        this.template.sendBody("direct:a", (Object)message);
        this.assertMockEndpointsSatisfied();
        StreamCachingInterceptorTest.assertTrue((boolean)(this.a.assertExchangeReceived(0).getIn().getBody() instanceof StreamCache));
        StreamCachingInterceptorTest.assertEquals((String)((String)this.a.assertExchangeReceived(0).getIn().getBody(String.class)), (String)MESSAGE);
    }

    public void testIgnoreAlreadyRereadable() throws Exception {
        this.a.expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)MESSAGE);
        this.assertMockEndpointsSatisfied();
        StreamCachingInterceptorTest.assertTrue((boolean)(this.a.assertExchangeReceived(0).getIn().getBody() instanceof String));
    }

    public void testStreamCachingInterceptorToString() {
        StreamCachingInterceptor cache = new StreamCachingInterceptor();
        StreamCachingInterceptorTest.assertNotNull((Object)cache.toString());
        StreamCaching caching = new StreamCaching();
        StreamCachingInterceptorTest.assertNotNull((Object)caching.toString());
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a = this.getMockEndpoint("mock:a");
        this.b = this.getMockEndpoint("mock:b");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").streamCaching().to("mock:a");
                StreamCachingInterceptorTest.this.context.setStreamCaching(Boolean.valueOf(true));
                this.from("direct:b").to("mock:b");
            }
        };
    }
}

