/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.DefaultTraceEventMessage;
import org.apache.camel.processor.interceptor.TraceEventMessage;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;

public class TraceInterceptorDestinationTest
extends ContextTestSupport {
    private List<String> tracedBodies = new ArrayList<String>();
    private List<String> tracedHeaders = new ArrayList<String>();

    public void testSendingSomeMessagesBeingTraced() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Bye World", "Foo World", "Foo World"});
        MockEndpoint mock = this.getMockEndpoint("mock:traced");
        mock.expectedMessageCount(8);
        ((ValueBuilder)mock.message(0).body()).regex("^direct://start;.*;.*;Hello London");
        ((ValueBuilder)mock.message(1).body()).regex("^direct://start;.*;.*;Hello World");
        ((ValueBuilder)mock.message(2).body()).regex("^direct://start;.*;.*;Goodday World");
        ((ValueBuilder)mock.message(3).body()).regex("^direct://start;.*;.*;Bye World");
        ((ValueBuilder)mock.message(4).body()).regex("^direct://foo;.*;.*;Hello Copenhagen");
        ((ValueBuilder)mock.message(5).body()).regex("^direct://foo;.*;.*;Foo World");
        ((ValueBuilder)mock.message(6).body()).regex("^direct://foo;.*;.*;Hello Beijing");
        ((ValueBuilder)mock.message(7).body()).regex("^direct://foo;.*;.*;Foo World");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello London", "to", (Object)"James");
        this.template.sendBody("direct:foo", (Object)"Hello Copenhagen");
        this.template.sendBody("direct:foo", (Object)"Hello Beijing");
        this.assertMockEndpointsSatisfied();
        TraceInterceptorDestinationTest.assertEquals((String)"Hello London", (String)this.tracedBodies.get(0));
        TraceInterceptorDestinationTest.assertEquals((String)"Hello World", (String)this.tracedBodies.get(1));
        TraceInterceptorDestinationTest.assertEquals((String)"Goodday World", (String)this.tracedBodies.get(2));
        TraceInterceptorDestinationTest.assertEquals((String)"Bye World", (String)this.tracedBodies.get(3));
        TraceInterceptorDestinationTest.assertEquals((String)"Hello Copenhagen", (String)this.tracedBodies.get(4));
        TraceInterceptorDestinationTest.assertEquals((String)"Foo World", (String)this.tracedBodies.get(5));
        TraceInterceptorDestinationTest.assertEquals((String)"Hello Beijing", (String)this.tracedBodies.get(6));
        TraceInterceptorDestinationTest.assertEquals((String)"Foo World", (String)this.tracedBodies.get(7));
        TraceInterceptorDestinationTest.assertTrue((String)this.tracedHeaders.get(0), (boolean)this.tracedHeaders.get(0).contains("to=James"));
        TraceInterceptorDestinationTest.assertTrue((String)this.tracedHeaders.get(1), (boolean)this.tracedHeaders.get(1).contains("to=Hello"));
        TraceInterceptorDestinationTest.assertTrue((String)this.tracedHeaders.get(2), (boolean)this.tracedHeaders.get(2).contains("to=Goodday"));
        TraceInterceptorDestinationTest.assertTrue((String)this.tracedHeaders.get(3), (boolean)this.tracedHeaders.get(3).contains("to=Bye"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                Tracer tracer = new Tracer();
                tracer.setDestinationUri("direct:traced");
                tracer.setLogLevel(LoggingLevel.OFF);
                this.getContext().addInterceptStrategy((InterceptStrategy)tracer);
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor("Hello World"))).process((Processor)new MyProcessor("Goodday World"))).process((Processor)new MyProcessor("Bye World"))).to("mock:result");
                ((RouteDefinition)this.from("direct:foo").process((Processor)new MyProcessor("Foo World"))).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:traced").process((Processor)new MyTraveAssertProcessor())).process((Processor)new MyTraceMessageProcessor())).to("mock:traced");
            }
        };
    }

    class MyTraceMessageProcessor
    implements Processor {
        MyTraceMessageProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            TraceEventMessage msg = (TraceEventMessage)exchange.getIn().getBody(DefaultTraceEventMessage.class);
            String s = msg.getFromEndpointUri() + ";" + msg.getToNode() + ";" + msg.getExchangeId() + ";" + msg.getBody();
            exchange.getIn().setBody((Object)s);
        }
    }

    class MyTraveAssertProcessor
    implements Processor {
        MyTraveAssertProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            String nodeId = (String)exchange.getProperty("CamelTraceEventNodeId", String.class);
            Date timestamp = (Date)exchange.getProperty("CamelTraceEventTimestamp", Date.class);
            TestCase.assertNotNull((Object)nodeId);
            TestCase.assertNotNull((Object)timestamp);
            TraceEventMessage msg = (TraceEventMessage)exchange.getIn().getBody(DefaultTraceEventMessage.class);
            TraceInterceptorDestinationTest.this.tracedBodies.add(msg.getBody());
            if (msg.getHeaders() != null) {
                TraceInterceptorDestinationTest.this.tracedHeaders.add(msg.getHeaders());
            }
        }
    }

    class MyProcessor
    implements Processor {
        private String msg;

        MyProcessor(String msg) {
            this.msg = msg;
        }

        public void process(Exchange exchange) throws Exception {
            exchange.getIn().setBody((Object)this.msg);
            exchange.getIn().setHeader("to", (Object)this.msg.split(" ")[0]);
        }
    }
}

