/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import junit.framework.TestCase;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class ContextScopedOnExceptionCorrectRouteContextTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testContextScopedOnExceptionLogRouteBarFail() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.onException(Exception.class).log("Error due ${exception.message}")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String routeId = exchange.getUnitOfWork().getRouteContext().getRoute().getId();
                        TestCase.assertEquals((String)"bar", (String)routeId);
                    }
                });
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("mock:foo")).to("direct:bar")).to("mock:result");
                ((RouteDefinition)this.from("direct:bar").routeId("bar").to("mock:bar")).throwException((Exception)new IllegalArgumentException("Forced bar error"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            ContextScopedOnExceptionCorrectRouteContextTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            IllegalArgumentException cause = ContextScopedOnExceptionCorrectRouteContextTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            ContextScopedOnExceptionCorrectRouteContextTest.assertEquals((String)"Forced bar error", (String)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testContextScopedOnExceptionLogRouteFooFail() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.onException(Exception.class).log("Error due ${exception.message}")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String routeId = exchange.getUnitOfWork().getRouteContext().getRoute().getId();
                        TestCase.assertEquals((String)"foo", (String)routeId);
                    }
                });
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("mock:foo")).throwException((Exception)new IllegalArgumentException("Forced foo error"))).to("direct:bar")).to("mock:result");
                this.from("direct:bar").routeId("bar").to("mock:bar");
                this.from("direct:killer").routeId("killer").to("mock:killer");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            ContextScopedOnExceptionCorrectRouteContextTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            IllegalArgumentException cause = ContextScopedOnExceptionCorrectRouteContextTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            ContextScopedOnExceptionCorrectRouteContextTest.assertEquals((String)"Forced foo error", (String)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }
}

