/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import javax.xml.namespace.QName;
import org.apache.camel.support.XMLTokenExpressionIterator;
import org.junit.Assert;
import org.junit.Test;

public class AttributedQNameTest
extends Assert {
    @Test
    public void testMatches() {
        XMLTokenExpressionIterator.AttributedQName aqname = new XMLTokenExpressionIterator.AttributedQName("urn:foo", "petra");
        AttributedQNameTest.assertTrue((boolean)aqname.matches(new QName("urn:foo", "petra")));
        AttributedQNameTest.assertFalse((boolean)aqname.matches(new QName("urn:bar", "petra")));
        AttributedQNameTest.assertFalse((boolean)aqname.matches(new QName("urn:foo", "petira")));
        aqname = new XMLTokenExpressionIterator.AttributedQName("urn:foo", "*tra");
        AttributedQNameTest.assertTrue((boolean)aqname.matches(new QName("urn:foo", "petra")));
        AttributedQNameTest.assertTrue((boolean)aqname.matches(new QName("urn:foo", "astra")));
        AttributedQNameTest.assertFalse((boolean)aqname.matches(new QName("urn:foo", "sandra")));
        aqname = new XMLTokenExpressionIterator.AttributedQName("urn:foo", "pe*");
        AttributedQNameTest.assertTrue((boolean)aqname.matches(new QName("urn:foo", "petra")));
        AttributedQNameTest.assertFalse((boolean)aqname.matches(new QName("urn:foo", "astra")));
        AttributedQNameTest.assertTrue((boolean)aqname.matches(new QName("urn:foo", "peach")));
        AttributedQNameTest.assertTrue((boolean)aqname.matches(new QName("urn:foo", "peteria")));
        aqname = new XMLTokenExpressionIterator.AttributedQName("urn:foo", "p*t*a");
        AttributedQNameTest.assertTrue((boolean)aqname.matches(new QName("urn:foo", "petra")));
        AttributedQNameTest.assertFalse((boolean)aqname.matches(new QName("urn:foo", "astra")));
        AttributedQNameTest.assertFalse((boolean)aqname.matches(new QName("urn:foo", "pesandra")));
        AttributedQNameTest.assertTrue((boolean)aqname.matches(new QName("urn:foo", "patricia")));
        aqname = new XMLTokenExpressionIterator.AttributedQName("urn:foo", "p?t?a");
        AttributedQNameTest.assertTrue((boolean)aqname.matches(new QName("urn:foo", "petra")));
        AttributedQNameTest.assertTrue((boolean)aqname.matches(new QName("urn:foo", "patia")));
        AttributedQNameTest.assertFalse((boolean)aqname.matches(new QName("urn:foo", "patricia")));
        aqname = new XMLTokenExpressionIterator.AttributedQName("urn:foo", "de.petra");
        AttributedQNameTest.assertTrue((boolean)aqname.matches(new QName("urn:foo", "de.petra")));
        aqname = new XMLTokenExpressionIterator.AttributedQName("urn:foo", "de.pe*");
        AttributedQNameTest.assertTrue((boolean)aqname.matches(new QName("urn:foo", "de.petra")));
        AttributedQNameTest.assertTrue((boolean)aqname.matches(new QName("urn:foo", "de.peach")));
        AttributedQNameTest.assertFalse((boolean)aqname.matches(new QName("urn:foo", "delpeach")));
        aqname = new XMLTokenExpressionIterator.AttributedQName("*", "p*a");
        AttributedQNameTest.assertTrue((boolean)aqname.matches(new QName("urn:foo", "petra")));
        AttributedQNameTest.assertTrue((boolean)aqname.matches(new QName("urn:bar", "patia")));
        AttributedQNameTest.assertTrue((boolean)aqname.matches(new QName("", "patricia")));
        AttributedQNameTest.assertFalse((boolean)aqname.matches(new QName("urn:bar", "peach")));
    }
}

